/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class JSInspection
extends LocalInspectionTool {
    protected boolean myOnTheFly;

    @NotNull
    protected abstract PsiElementVisitor createVisitor(ProblemsHolder var1, LocalInspectionToolSession var2);

    @NotNull
    public String getShortName() {
        String string = JSInspection.calcShortNameFromClass(((Object)((Object)this)).getClass());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspection", "getShortName"));
        }
        return string;
    }

    public static String calcShortNameFromClass(Class aClass) {
        String name = aClass.getName();
        while (name.indexOf(36) != -1) {
            aClass = aClass.getSuperclass();
            name = aClass.getName();
        }
        name = name.substring(name.lastIndexOf(46) + 1);
        name = InspectionProfileEntry.getShortName((String)name);
        return name;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSInspection", "buildVisitor"));
        }
        this.myOnTheFly = isOnTheFly;
        PsiElementVisitor psiElementVisitor = this.createVisitor(holder, session);
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    protected PsiElementVisitor baseVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/inspections/JSInspection", "baseVisitor"));
        }
        this.myOnTheFly = isOnTheFly;
        return super.buildVisitor(holder, this.myOnTheFly);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"JavaScript", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspection", "getGroupPath"));
        }
        return stringArray;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public PsiNamedElement getProblemElement(PsiElement psiElement) {
        JSNamedElement namedParent = (JSNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSNamedElement.class});
        if (namedParent != null) {
            return namedParent;
        }
        return super.getProblemElement(psiElement);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.inspection.group.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    protected JComponent createSingleCheckboxOptionsPanelWithHint(String label, String hint, String fieldName) {
        SingleCheckboxOptionsPanel checkBoxPanel = new SingleCheckboxOptionsPanel(label, (InspectionProfileEntry)this, fieldName);
        JCheckBox checkBox = (JCheckBox)checkBoxPanel.getComponents()[0];
        checkBox.setToolTipText(hint);
        return checkBoxPanel;
    }
}

