/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class NewLineEraser {
    private PsiElement myParent;
    private final PsiElement myCause;
    private PsiWhiteSpace myPrev;
    private int myPrevNum = 0;
    private PsiWhiteSpace myNext;
    private int myNextNum = 0;
    private boolean myCutNewlinesAtEnd;
    private PsiElement myEquivalent;

    public NewLineEraser(PsiElement cause) {
        this.myCause = cause;
        this.myParent = this.myCause.getParent();
        if (this.myCause.getPrevSibling() instanceof PsiWhiteSpace) {
            this.myPrev = (PsiWhiteSpace)this.myCause.getPrevSibling();
            this.myPrevNum = NewLineEraser.countNewLines(this.myPrev, false);
        }
        if (this.myCause.getNextSibling() instanceof PsiWhiteSpace) {
            this.myNext = (PsiWhiteSpace)this.myCause.getNextSibling();
            this.myNextNum = NewLineEraser.countNewLines(this.myNext, true);
        } else if (this.myCause.getNextSibling() == null) {
            this.myCutNewlinesAtEnd = true;
        }
    }

    public void process() {
        if (this.myCause.isValid()) {
            return;
        }
        if (this.myEquivalent != null) {
            this.process(this.myEquivalent);
        } else {
            this.processImpl();
        }
    }

    private void processImpl() {
        this.zipRecordedNewLines();
        if (this.myCutNewlinesAtEnd && this.myParent != null && this.myParent.isValid()) {
            this.cutAtEnd();
        }
    }

    public void process(@NotNull PsiElement equivalent) {
        if (equivalent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equivalent", "com/intellij/lang/javascript/inspections/NewLineEraser", "process"));
        }
        NewLineEraser equivalentEraser = new NewLineEraser(equivalent);
        equivalentEraser.myPrevNum = this.myPrevNum;
        equivalentEraser.myNextNum = this.myNextNum;
        equivalentEraser.myCutNewlinesAtEnd = this.myCutNewlinesAtEnd;
        equivalentEraser.processImpl();
    }

    public void registerEquivalent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/NewLineEraser", "registerEquivalent"));
        }
        this.myEquivalent = element;
    }

    private static int countNewLines(@NotNull PsiWhiteSpace space, boolean forward) {
        if (space == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "space", "com/intellij/lang/javascript/inspections/NewLineEraser", "countNewLines"));
        }
        int cnt = 0;
        PsiWhiteSpace current = space;
        while (current instanceof PsiWhiteSpace) {
            cnt += StringUtil.countNewLines((CharSequence)current.getText());
            current = forward ? current.getNextSibling() : current.getPrevSibling();
        }
        return cnt;
    }

    private void cutAtEnd() {
        PsiElement child = this.myParent.getLastChild();
        while (child instanceof PsiWhiteSpace) {
            PsiElement tmp = child.getPrevSibling();
            child.delete();
            child = tmp;
        }
    }

    private void zipRecordedNewLines() {
        if (this.myPrev != null && this.myNext != null && this.myPrev.isValid() && this.myNext.isValid() && this.myPrev.getNextSibling().equals(this.myNext)) {
            NewLineEraser.zipNewLines(this.myPrev, this.myPrevNum + this.myNextNum - 1);
            return;
        }
        if (this.myPrev != null && NewLineEraser.zipNewLines(this.myPrev, this.myPrevNum)) {
            return;
        }
        if (this.myNext != null) {
            NewLineEraser.zipNewLines(this.myNext, this.myNextNum);
        }
    }

    private static boolean zipNewLines(PsiWhiteSpace space, int num) {
        if (!space.isValid()) {
            return false;
        }
        ArrayDeque<PsiWhiteSpace> spaces = new ArrayDeque<PsiWhiteSpace>();
        spaces.add(space);
        PsiElement current = space.getPrevSibling();
        while (current instanceof PsiWhiteSpace) {
            spaces.addFirst((PsiWhiteSpace)current);
            current = current.getPrevSibling();
        }
        current = space.getNextSibling();
        while (current instanceof PsiWhiteSpace) {
            spaces.addLast((PsiWhiteSpace)current);
            current = current.getNextSibling();
        }
        int cntNewLines = 0;
        for (PsiWhiteSpace whiteSpace : spaces) {
            String text = whiteSpace.getText();
            int newLines = StringUtil.countNewLines((CharSequence)text);
            if (newLines < 1) continue;
            if (cntNewLines + newLines > num) {
                String newText = text;
                int cnt = cntNewLines + newLines - num;
                while (cnt-- > 0) {
                    newText = newText.replaceFirst("\n", "");
                }
                if (!newText.isEmpty()) {
                    JSChangeUtil.addWs(whiteSpace.getParent().getNode(), whiteSpace.getNode(), newText);
                }
                whiteSpace.delete();
                continue;
            }
            cntNewLines += newLines;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewLineEraser eraser = (NewLineEraser)o;
        if (this.myPrevNum != eraser.myPrevNum) {
            return false;
        }
        if (this.myNextNum != eraser.myNextNum) {
            return false;
        }
        return this.myCutNewlinesAtEnd == eraser.myCutNewlinesAtEnd;
    }

    public int hashCode() {
        int result = this.myPrevNum;
        result = 31 * result + this.myNextNum;
        result = 31 * result + (this.myCutNewlinesAtEnd ? 1 : 0);
        return result;
    }
}

