/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import org.jetbrains.annotations.NotNull;

public class JSHintState
implements JSLinterState {
    private final JSHintOptionsState myOptionsState;
    private final String myVersion;
    private final boolean myConfigFileUsed;
    private final boolean myCustomConfigFileUsed;
    private final String myCustomConfigFilePath;

    private JSHintState(@NotNull JSHintOptionsState optionsState, @NotNull String version, boolean configFileUsed, boolean customConfigFileUsed, @NotNull String customConfigFilePath) {
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/JSHintState", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintState", "<init>"));
        }
        if (customConfigFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customConfigFilePath", "com/intellij/lang/javascript/linter/jshint/JSHintState", "<init>"));
        }
        this.myOptionsState = optionsState;
        this.myVersion = version;
        this.myConfigFileUsed = configFileUsed;
        this.myCustomConfigFileUsed = customConfigFileUsed;
        this.myCustomConfigFilePath = customConfigFilePath;
    }

    @NotNull
    public JSHintOptionsState getOptionsState() {
        JSHintOptionsState jSHintOptionsState = this.myOptionsState;
        if (jSHintOptionsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState", "getOptionsState"));
        }
        return jSHintOptionsState;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = this.myCustomConfigFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState", "getCustomConfigFilePath"));
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState", "getVersion"));
        }
        return string;
    }

    public boolean isConfigFileUsed() {
        return this.myConfigFileUsed;
    }

    public String toString() {
        return "JSHintState{version=" + this.myVersion + ", options=" + this.myOptionsState + ", configFileUsed=" + this.myConfigFileUsed + ", customConfigFileUsed=" + this.myCustomConfigFileUsed + ", customConfigFilePath=" + this.myCustomConfigFilePath + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSHintState state = (JSHintState)o;
        if (!this.myVersion.equals(state.getVersion())) {
            return false;
        }
        if (this.myConfigFileUsed != state.isConfigFileUsed()) {
            return false;
        }
        if (this.myCustomConfigFileUsed != state.isCustomConfigFileUsed()) {
            return false;
        }
        if (!this.myCustomConfigFilePath.equals(state.getCustomConfigFilePath())) {
            return false;
        }
        return this.myOptionsState.equals(state.myOptionsState);
    }

    public int hashCode() {
        int result = this.myOptionsState.hashCode();
        result = 31 * result + this.myVersion.hashCode();
        result = 31 * result + (this.myConfigFileUsed ? 1 : 0);
        result = 31 * result + (this.myCustomConfigFileUsed ? 1 : 0);
        result = 31 * result + this.myCustomConfigFilePath.hashCode();
        return result;
    }

    public static class Builder {
        private JSHintOptionsState myOptionsState;
        private String myVersion;
        private boolean myConfigFileUsed;
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;

        public Builder() {
            this.myVersion = "2.9.5";
            this.myConfigFileUsed = false;
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
        }

        public Builder(@NotNull JSHintState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "<init>"));
            }
            this.myVersion = "2.9.5";
            this.myConfigFileUsed = false;
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.setOptionsState(state.getOptionsState());
            this.setVersion(state.getVersion());
            this.setConfigFileUsed(state.isConfigFileUsed());
            this.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
            this.setCustomConfigFilePath(state.getCustomConfigFilePath());
        }

        public Builder setOptionsState(@NotNull JSHintOptionsState optionsState) {
            if (optionsState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setOptionsState"));
            }
            this.myOptionsState = optionsState;
            return this;
        }

        @NotNull
        public Builder setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setVersion"));
            }
            this.myVersion = version;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setVersion"));
            }
            return builder;
        }

        @NotNull
        public Builder setConfigFileUsed(boolean configFileUsed) {
            this.myConfigFileUsed = configFileUsed;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setConfigFileUsed"));
            }
            return builder;
        }

        @NotNull
        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setCustomConfigFileUsed"));
            }
            return builder;
        }

        @NotNull
        public Builder setCustomConfigFilePath(@NotNull String customConfigFilePath) {
            if (customConfigFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customConfigFilePath", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setCustomConfigFilePath"));
            }
            this.myCustomConfigFilePath = customConfigFilePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintState$Builder", "setCustomConfigFilePath"));
            }
            return builder;
        }

        public JSHintState build() {
            return new JSHintState(this.myOptionsState, this.myVersion, this.myConfigFileUsed, this.myCustomConfigFileUsed, this.myCustomConfigFilePath);
        }
    }
}

