/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JsDefinedInObject;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceExpressionInfo
implements ModuleReferenceInfo {
    @Nullable
    private final String myContextName;
    @Nullable
    private final String myParentName;
    @Nullable
    private final JSReferenceExpression myParent;
    @NotNull
    private final List<JSReferenceExpression> myTailRefs;

    public JSModuleReferenceExpressionInfo(@NotNull JSReferenceExpression node) {
        String referenceName;
        String name;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "<init>"));
        }
        this.myContextName = node.getReferenceName();
        PsiElement parent = JSModuleReferenceExpressionInfo.getParentElement(node);
        String string = name = parent == null ? null : ((JSReferenceExpression)parent).getReferenceName();
        if (name == null || JsDefinedInObject.isPredefined(name, DialectDetector.dialectOfFile(node.getContainingFile()))) {
            this.myParent = null;
            this.myParentName = null;
            this.myTailRefs = ContainerUtil.emptyList();
            return;
        }
        this.myParentName = name;
        this.myParent = (JSReferenceExpression)parent;
        ArrayList<JSReferenceExpression> result = new ArrayList<JSReferenceExpression>();
        while (parent instanceof JSReferenceExpression && (referenceName = ((JSReferenceExpression)parent).getReferenceName()) != null) {
            result.add((JSReferenceExpression)parent);
            parent = parent.getParent();
        }
        this.myTailRefs = result;
    }

    @Nullable
    private static PsiElement getParentElement(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "getParentElement"));
        }
        if (node.getParent() instanceof JSNewExpression) {
            PsiElement parentOverNewExpression = node.getParent().getParent();
            if (parentOverNewExpression instanceof JSReferenceExpression) {
                return parentOverNewExpression;
            }
        } else if (node.getParent() instanceof JSReferenceExpression) {
            return node.getParent();
        }
        return null;
    }

    @Override
    @NotNull
    public List<JSReferenceExpression> getTailRefs() {
        List<JSReferenceExpression> list = this.myTailRefs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "getTailRefs"));
        }
        return list;
    }

    @Override
    public boolean processFromIndex() {
        return false;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getResolvedParent() {
        JSReferenceExpression ref = this.myParent;
        Collection<Object> collection = ref == null ? ContainerUtil.emptyList() : JSResolveResult.toElements(ref.multiResolve(false));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "getResolvedParent"));
        }
        return collection;
    }

    @Override
    public boolean isAcceptable(@NotNull PsiElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "isAcceptable"));
        }
        return true;
    }

    @Override
    @Nullable
    public String getContextName() {
        return this.myContextName;
    }

    @Override
    public boolean needHint() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement getParentRef() {
        return this.myParent;
    }

    @Override
    @Nullable
    public String getParentName() {
        return this.myParentName;
    }
}

