/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.lang.javascript.modules.diagramm.ES6ModuleDataNode;
import com.intellij.lang.javascript.modules.diagramm.JSModuleConnectionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportedData {
    private boolean myLogicalImport;
    @NotNull
    private final String mySourceName;
    @NotNull
    private final String myTargetName;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myTargetMemberPointer;
    @NotNull
    private final ES6ModuleDataNode myTargetNode;
    @Nullable
    private JSModuleConnectionProvider myProvider;
    @Nullable
    private Icon myIcon;

    public ImportedData(@NotNull String sourceName, @NotNull String targetName, @Nullable SmartPsiElementPointer<PsiElement> targetMemberPointer, @NotNull ES6ModuleDataNode targetNode) {
        if (sourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceName", "com/intellij/lang/javascript/modules/diagramm/ImportedData", "<init>"));
        }
        if (targetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetName", "com/intellij/lang/javascript/modules/diagramm/ImportedData", "<init>"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/lang/javascript/modules/diagramm/ImportedData", "<init>"));
        }
        this.myLogicalImport = true;
        this.mySourceName = sourceName;
        this.myTargetName = targetName;
        this.myTargetMemberPointer = targetMemberPointer;
        this.myTargetNode = targetNode;
    }

    @NotNull
    public String getSourceName() {
        String string = this.mySourceName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/ImportedData", "getSourceName"));
        }
        return string;
    }

    @NotNull
    public String getTargetName() {
        String string = this.myTargetName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/ImportedData", "getTargetName"));
        }
        return string;
    }

    @Nullable
    public SmartPsiElementPointer<PsiElement> getTargetMemberPointer() {
        return this.myTargetMemberPointer;
    }

    @NotNull
    public ES6ModuleDataNode getTargetNode() {
        ES6ModuleDataNode eS6ModuleDataNode = this.myTargetNode;
        if (eS6ModuleDataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/ImportedData", "getTargetNode"));
        }
        return eS6ModuleDataNode;
    }

    @Nullable
    public JSModuleConnectionProvider getProvider() {
        return this.myProvider;
    }

    public void setProvider(@Nullable JSModuleConnectionProvider provider) {
        this.myProvider = provider;
    }

    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isLogicalImport() {
        return this.myLogicalImport;
    }

    public ImportedData setLogicalImport(boolean logicalImport) {
        this.myLogicalImport = logicalImport;
        return this;
    }
}

