/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramProvider;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiNode;
import com.intellij.lang.javascript.modules.diagramm.Rainbow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralDiagramModel
extends DiagramDataModel<JSStructuralDiagramItem> {
    private final List<JSStructuralUiNode> myNodes;
    private final List<JSStructuralUiEdge> myEdges;
    private final ModificationTracker myModificationTracker;
    private final CachedColorGenerator myColoredGenerator;
    private final CachedColorGenerator myGrayGenerator;
    private final CachedColorGenerator myInProjectGenerator;

    public JSStructuralDiagramModel(@NotNull Project project, @NotNull JSModulesDiagramProvider provider, List<JSStructuralUiNode> nodes, List<JSStructuralUiEdge> edges) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel", "<init>"));
        }
        super(project, (DiagramProvider)provider);
        this.myNodes = nodes;
        this.myEdges = edges;
        this.myModificationTracker = new ModificationTracker(){

            public long getModificationCount() {
                return 0L;
            }
        };
        this.myColoredGenerator = new CachedColorGenerator(Rainbow.createGenerator((Condition<Rainbow.ColorGroup>)((Condition)cg -> !Rainbow.ColorGroup.light_gray.equals(cg) && !Rainbow.ColorGroup.gray.equals(cg) && !Rainbow.ColorGroup.light_yellow.equals(cg) && !Rainbow.ColorGroup.yellow.equals(cg)), null, !UIUtil.isUnderDarcula()));
        this.myGrayGenerator = new CachedColorGenerator(Rainbow.createGenerator((Condition<Rainbow.ColorGroup>)((Condition)cg -> Rainbow.ColorGroup.light_gray.equals(cg) || Rainbow.ColorGroup.grayForDarculaBg.equals(cg)), null, !UIUtil.isUnderDarcula()));
        this.myInProjectGenerator = new CachedColorGenerator(() -> LightColors.YELLOW);
    }

    public void dispose() {
    }

    @NotNull
    public Collection<? extends DiagramNode<JSStructuralDiagramItem>> getNodes() {
        List<JSStructuralUiNode> list = this.myNodes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel", "getNodes"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends DiagramEdge<JSStructuralDiagramItem>> getEdges() {
        List<JSStructuralUiEdge> list = this.myEdges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel", "getEdges"));
        }
        return list;
    }

    @NotNull
    public String getNodeName(DiagramNode<JSStructuralDiagramItem> n) {
        String string = n.getTooltip();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel", "getNodeName"));
        }
        return string;
    }

    @Nullable
    public DiagramNode<JSStructuralDiagramItem> addElement(JSStructuralDiagramItem element) {
        return null;
    }

    public void refreshDataModel() {
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = this.myModificationTracker;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel", "getModificationTracker"));
        }
        return modificationTracker;
    }

    public CachedColorGenerator getColoredGenerator() {
        return this.myColoredGenerator;
    }

    public CachedColorGenerator getGrayGenerator() {
        return this.myGrayGenerator;
    }

    public CachedColorGenerator getInProjectGenerator() {
        return this.myInProjectGenerator;
    }

    public static class CachedColorGenerator {
        private final Rainbow.ColorGenerator myGenerator;
        private final Map<String, Color> myCache = new HashMap<String, Color>();

        public CachedColorGenerator(Rainbow.ColorGenerator generator) {
            this.myGenerator = generator;
        }

        public Color generate(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramModel$CachedColorGenerator", "generate"));
            }
            Color color = this.myCache.get(name);
            if (color != null) {
                return color;
            }
            color = this.myGenerator.getColor();
            this.myCache.put(name, color);
            return color;
        }
    }
}

