/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionScriptClassBase<StubT extends JSQualifiedStub<?>>
extends JSClassBase<StubT> {
    @NotNull
    private volatile ThreeState myHasBindableMembers = ThreeState.UNSURE;

    protected ActionScriptClassBase(ASTNode node) {
        super(node);
    }

    public ActionScriptClassBase(StubT stub, IStubElementType<StubT, ?> aClass) {
        super(stub, aClass);
    }

    static boolean isImplicitlyDeclaringEventDispatcher(JSClass clazz) {
        if (!(clazz instanceof ActionScriptClassBase)) {
            return false;
        }
        if (ActionScriptResolveUtil.isImplicitlyDeclaringEventDispatcher(clazz.getAttributeList())) {
            return true;
        }
        ActionScriptClassBase c = (ActionScriptClassBase)clazz;
        if (c.myHasBindableMembers == ThreeState.UNSURE) {
            c.initFields();
        }
        if (c.myHasBindableMembers == ThreeState.UNSURE) {
            c.initFunctions();
        }
        if (c.myHasBindableMembers == ThreeState.UNSURE) {
            c.myHasBindableMembers = ThreeState.NO;
        }
        return c.myHasBindableMembers == ThreeState.YES;
    }

    @Override
    @NotNull
    protected <E extends PsiElement> E[] getStubChildrenByType(StubElement<?> stub, ArrayFactory<E> f, TokenSet set) {
        assert (!set.contains(JSStubElementTypes.INCLUDE_DIRECTIVE));
        ArrayList result = ContainerUtil.newArrayList((Object[])stub.getChildrenByType(set, f));
        JSIncludeDirective[] includes = (JSIncludeDirective[])stub.getChildrenByType(JSStubElementTypes.INCLUDE_DIRECTIVE, JSIncludeDirective[]::new);
        THashSet visited = new THashSet();
        TokenSet filter = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.INCLUDE_DIRECTIVE})});
        for (JSIncludeDirective include : includes) {
            PsiFile file = include.resolveFile();
            if (!(file instanceof JSFile)) continue;
            ActionScriptResolveUtil.processIncludedFiles(filter, (JSFile)file, result, (Collection<JSFile>)visited);
        }
        PsiElement[] psiElementArray = (PsiElement[])result.toArray(f.create(result.size()));
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase", "getStubChildrenByType"));
        }
        return psiElementArray;
    }

    @Override
    protected void updateStateForField(@NotNull JSField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase", "updateStateForField"));
        }
        if (this.myHasBindableMembers == ThreeState.UNSURE && ActionScriptResolveUtil.isImplicitlyDeclaringEventDispatcher(field.getAttributeList())) {
            this.myHasBindableMembers = ThreeState.YES;
        }
    }

    @Override
    protected void updateStateForFunction(@NotNull JSFunction function) {
        JSAttributeList attributeList;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase", "updateStateForFunction"));
        }
        if (this.myHasBindableMembers == ThreeState.UNSURE && JSPsiImplUtils.isGetterOrSetter(function) && (attributeList = function.getAttributeList()) != null && !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && ActionScriptResolveUtil.isImplicitlyDeclaringEventDispatcher(attributeList)) {
            this.myHasBindableMembers = ThreeState.YES;
        }
    }

    private boolean isImplicitlyDeclared(JSClass clazz) {
        return ActionScriptClassBase.isImplicitlyDeclaringEventDispatcher(this) && "flash.events.IEventDispatcher".equals(clazz.getQualifiedName());
    }

    @Override
    @NotNull
    public Collection<JSClass> getImplicitlyDeclaredInterfaces() {
        SmartList classes = null;
        for (JSClass clazz : this.getImplementedInterfaces()) {
            if (!this.isImplicitlyDeclared(clazz)) continue;
            if (classes == null) {
                classes = new SmartList();
            }
            classes.add((JSClass)clazz);
        }
        SmartList smartList = classes != null ? classes : Collections.emptyList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase", "getImplicitlyDeclaredInterfaces"));
        }
        return smartList;
    }

    @Override
    public JSFunction getConstructor() {
        return this.findFunctionByName(this.getName());
    }

    @Override
    protected boolean needProcessClass(@Nullable ResolveProcessor resolveProcessor, @Nullable PsiElement place) {
        return super.needProcessClass(resolveProcessor, place) && !this.needResolveReferenceInOtherFile(resolveProcessor, place);
    }

    protected boolean needResolveReferenceInOtherFile(ResolveProcessor resolveProcessor, @Nullable PsiElement place) {
        return DialectDetector.isActionScript((PsiElement)this.getContainingFile()) && resolveProcessor != null && resolveProcessor.isTypeContext() && resolveProcessor.getName() != null && place instanceof JSReferenceExpression && place.getContainingFile().getOriginalFile() != this.getContainingFile().getOriginalFile();
    }

    @Override
    protected JSClass[] getSuperClassesForProcess(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase", "getSuperClassesForProcess"));
        }
        return (JSClass[])JSInheritanceUtil.withEnforcedScope(this::getSuperClasses, JSResolveUtil.getResolveScope(place));
    }

    @Override
    protected String getMethodName(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/ecmal4/impl/ActionScriptClassBase", "getMethodName"));
        }
        return ActionScriptResolveUtil.replaceInternalName(function.getName());
    }

    @Override
    protected void clearCachesSync() {
        super.clearCachesSync();
        this.myHasBindableMembers = ThreeState.UNSURE;
    }
}

