/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBinaryExpressionImpl
extends JSExpressionImpl
implements JSBinaryExpression {
    public JSBinaryExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    private static TokenSet getExtendedBinaryOperations() {
        return Holder.ourExtendedBinaryOperations;
    }

    public JSExpression getLOperand() {
        ASTNode lOperandNode = JSBinaryExpressionImpl.getLOperandNode(this.getNode());
        return lOperandNode != null ? (JSExpression)lOperandNode.getPsi() : null;
    }

    @Nullable
    public static ASTNode getLOperandNode(@NotNull ASTNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/lang/javascript/psi/impl/JSBinaryExpressionImpl", "getLOperandNode"));
        }
        ASTNode firstExpression = astNode.findChildByType(JSElementTypes.EXPRESSIONS);
        if (firstExpression != null && astNode.findChildByType(JSBinaryExpressionImpl.getExtendedBinaryOperations(), firstExpression) == null) {
            return null;
        }
        return firstExpression;
    }

    public JSExpression getROperand() {
        ASTNode secondExpression = JSBinaryExpressionImpl.getROperandNode(this.getNode());
        return secondExpression != null ? (JSExpression)secondExpression.getPsi() : null;
    }

    @Nullable
    public static ASTNode getROperandNode(@NotNull ASTNode binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "com/intellij/lang/javascript/psi/impl/JSBinaryExpressionImpl", "getROperandNode"));
        }
        return binaryExpression.findChildByType(JSElementTypes.EXPRESSIONS, binaryExpression.findChildByType(JSBinaryExpressionImpl.getExtendedBinaryOperations()));
    }

    public PsiElement getOperator() {
        ASTNode operationASTNode = this.getNode().findChildByType(JSBinaryExpressionImpl.getExtendedBinaryOperations());
        return operationASTNode != null ? operationASTNode.getPsi() : null;
    }

    public IElementType getOperationSign() {
        ASTNode operationASTNode = JSBinaryExpressionImpl.getOperationSignNode(this.getNode());
        return operationASTNode != null ? operationASTNode.getElementType() : null;
    }

    public static ASTNode getOperationSignNode(@NotNull ASTNode binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "com/intellij/lang/javascript/psi/impl/JSBinaryExpressionImpl", "getOperationSignNode"));
        }
        return binaryExpression.findChildByType(JSBinaryExpressionImpl.getExtendedBinaryOperations());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSBinaryExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSBinaryExpression((JSBinaryExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static class Holder {
        static final TokenSet ourExtendedBinaryOperations = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.OPERATIONS, JSTokenTypes.RELATIONAL_OPERATIONS});

        private Holder() {
        }
    }
}

