/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringElementStubImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringElementImpl<StubT extends JSDestructuringElementStubImpl<?>>
extends JSStubElementImpl<StubT>
implements JSDestructuringElement,
StubBasedPsiElement<StubT>,
JSExpression {
    public JSDestructuringElementImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringElementImpl(StubT stub, IStubElementType<StubT, ?> elementType) {
        super(stub, elementType);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "processDeclarations"));
        }
        JSDestructuringContainer destructuringContainer = (JSDestructuringContainer)PsiTreeUtil.getChildOfType((PsiElement)this, JSDestructuringContainer.class);
        if (destructuringContainer != null) {
            return destructuringContainer.processDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringElement((JSDestructuringElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSDestructuringContainer getTarget() {
        PsiElement child = JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSElementTypes.DESTRUCTURING_CONTAINERS);
        return child instanceof JSDestructuringContainer ? (JSDestructuringContainer)child : null;
    }

    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Nullable
    public JSType getType() {
        JSTypeDeclaration element = this.getTypeElement();
        if (element != null) {
            return TypeScriptTypeParser.buildTypeFromTypeScript(element);
        }
        JSExpression initializer = this.getInitializer();
        if (initializer != null && DialectDetector.isTypeScript((PsiElement)this)) {
            return new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
        }
        return null;
    }

    @Nullable
    public JSTypeDeclaration getTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression(this, other);
    }
}

