/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocParamReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NotNull
    private JSDocTag myJSDocTag;
    @NotNull
    private TextRange myRangeInElement;
    @Nullable
    private final JSDocParamReference myQualifier;

    private JSDocParamReference(@NotNull JSDocTag elt, @NotNull TextRange rangeInElement, @Nullable JSDocParamReference qualifier) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "<init>"));
        }
        if (rangeInElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInElement", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "<init>"));
        }
        this.myJSDocTag = elt;
        this.myRangeInElement = rangeInElement;
        this.myQualifier = qualifier;
    }

    public PsiElement getElement() {
        return this.myJSDocTag;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getRangeInElement"));
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        int offsetInText = this.myRangeInElement.getStartOffset();
        String string = this.myJSDocTag.getText().substring(offsetInText, offsetInText + this.myRangeInElement.getLength());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myJSDocTag);
        this.myJSDocTag = (JSDocTag)manipulator.handleContentChange((PsiElement)this.myJSDocTag, this.myRangeInElement, newElementName);
        this.myRangeInElement = TextRange.from((int)this.myRangeInElement.getStartOffset(), (int)(this.myRangeInElement.getStartOffset() + newElementName.length()));
        return this.myJSDocTag;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element.isEquivalentTo(this.resolve());
    }

    private JSParameterList findParameterList() {
        JSDocComment docComment = this.getDocComment();
        return JSDocParamReference.findParameterList(docComment);
    }

    @Nullable
    public static JSParameterList findParameterList(@NotNull JSDocComment docComment) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "findParameterList"));
        }
        JSFunction function = JSDocumentationUtils.findFunctionAppliedTo(docComment);
        return function != null ? function.getParameterList() : null;
    }

    public PsiElement resolve() {
        if (this.myQualifier != null) {
            JSDestructuringContainer target;
            PsiElement destructuringElement;
            PsiElement qualifierResolve = this.myQualifier.resolve();
            Object object = qualifierResolve instanceof JSDestructuringParameter ? qualifierResolve : (destructuringElement = qualifierResolve instanceof JSDestructuringProperty ? ((JSDestructuringProperty)qualifierResolve).getDestructuringElement() : null);
            if (destructuringElement instanceof JSDestructuringElement && (target = ((JSDestructuringElement)destructuringElement).getTarget()) instanceof JSDestructuringObject) {
                return ((JSDestructuringObject)target).findProperty(this.getCanonicalText());
            }
            return null;
        }
        JSDocComment docComment = this.getDocComment();
        JSFunction function = JSDocumentationUtils.findFunctionAppliedTo(docComment);
        if (function != null) {
            JSParameter[] parameters;
            String name = this.getCanonicalText();
            if ("arguments".equals(name)) {
                return this.getElement();
            }
            HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
            JSDocumentationUtils.JSTagToParameterMap tagToParameters = JSDocumentationUtils.getTagToParameterMap(docComment, function, tagNames);
            for (Map.Entry entry : tagNames.entrySet()) {
                JSParameterListElement element;
                if (!name.equals(entry.getValue()) || (element = tagToParameters.getMatchedTags().get(entry.getKey())) == null) continue;
                return element;
            }
            for (JSParameter parameter : parameters = function.getParameterVariables()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    @NotNull
    private JSDocComment getDocComment() {
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myJSDocTag, JSDocComment.class);
        assert (docComment != null);
        JSDocComment jSDocComment = docComment;
        if (jSDocComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getDocComment"));
        }
        return jSDocComment;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.findParameterList() == null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JSBundle.message((String)"js.comment.matches.signature.inspection.problem2", (Object[])new Object[]{this.getCanonicalText()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public static PsiReference[] createReferences(@NotNull JSDocTag docTag) {
        if (docTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docTag", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "createReferences"));
        }
        List<TextRange> range = JSDocumentationUtils.getParameterNameRanges(docTag);
        if (range.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "createReferences"));
            }
            return EMPTY_ARRAY;
        }
        TextRange firstRange = range.get(0);
        JSDocParamReference firstRef = new JSDocParamReference(docTag, firstRange, null);
        if (range.size() > 1 && firstRef.resolve() instanceof JSDestructuringParameter) {
            JSDocParamReference qualifier = firstRef;
            PsiReference[] result = new PsiReference[range.size()];
            result[0] = firstRef;
            for (int i = 1; i < range.size(); ++i) {
                TextRange textRange = range.get(i);
                qualifier = new JSDocParamReference(docTag, textRange, qualifier);
                result[i] = qualifier;
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "createReferences"));
            }
            return result;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{firstRef};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "createReferences"));
        }
        return psiReferenceArray;
    }
}

