/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.frameworks.modules.JSParentReference;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSModuleReferenceContributor {
    public static final ExtensionPointName<JSModuleReferenceContributor> EP_NAME = ExtensionPointName.create((String)"JavaScript.moduleReferenceContributor");

    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String var1, @NotNull PsiElement var2, int var3, @Nullable PsiReferenceProvider var4);

    @NotNull
    public PsiReference[] getAllReferences(@NotNull String var1, @NotNull PsiElement var2, int var3, @Nullable PsiReferenceProvider var4);

    public boolean isApplicable(@NotNull PsiElement var1);

    public static PsiReference[] getReferencesForObjectLiteral(@Nullable JSLiteralExpression literalExpression, @Nullable PsiReferenceProvider provider, boolean commonjsReferencesOnly) {
        if (literalExpression == null || !literalExpression.isQuotedLiteral()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = literalExpression.getText();
        String unquoted = StringUtil.unquoteString((String)text);
        return JSModuleReferenceContributor.getReferences(unquoted, (PsiElement)literalExpression, 1, provider, commonjsReferencesOnly);
    }

    public static PsiReference[] getReferences(@NotNull String unquoted, @NotNull PsiElement context, int offset, @Nullable PsiReferenceProvider provider, boolean commonjsReferencesOnly) {
        if (unquoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquoted", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor", "getReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor", "getReferences"));
        }
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])EP_NAME.getExtensions()) {
            if (!contributor.isApplicable(context)) continue;
            Object[] references = commonjsReferencesOnly ? contributor.getCommonJSModuleReferences(unquoted, context, offset, provider) : contributor.getAllReferences(unquoted, context, offset, provider);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references);
        }
        return result;
    }

    @NotNull
    public static List<PsiElement> resolveModules(@NotNull PsiElement context, @NotNull String path, boolean isCommonJS) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor", "resolveModules"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor", "resolveModules"));
        }
        List result = ContainerUtil.newSmartList();
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])EP_NAME.getExtensions()) {
            PsiReference[] references;
            if (!contributor.isApplicable(context)) continue;
            for (PsiReference reference : references = isCommonJS ? contributor.getCommonJSModuleReferences(path, context, 0, null) : contributor.getAllReferences(path, context, 0, null)) {
                result.addAll(JSModuleReferenceContributor.resolveModuleReference(reference));
            }
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor", "resolveModules"));
        }
        return list;
    }

    public static Collection<PsiElement> resolveModuleReference(@Nullable PsiReference reference) {
        if (reference instanceof JSParentReference || reference == null || reference instanceof FileReference && !((FileReference)reference).isLast()) {
            return ContainerUtil.emptyList();
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            return JSResolveResult.toElements(results);
        }
        return ContainerUtil.createMaybeSingletonList((Object)reference.resolve());
    }

    public static Pair<Integer, String> getActualPath(@NotNull String modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor", "getActualPath"));
        }
        int resourcePathStartInd = modulePath.lastIndexOf(33);
        resourcePathStartInd = resourcePathStartInd >= 0 ? resourcePathStartInd + 1 : 0;
        int resourcePathEndInd = modulePath.indexOf(63, resourcePathStartInd);
        resourcePathEndInd = resourcePathEndInd >= 0 ? resourcePathEndInd : modulePath.length();
        String requiredModulePath = modulePath.substring(resourcePathStartInd, resourcePathEndInd);
        return Pair.create((Object)resourcePathStartInd, (Object)requiredModulePath);
    }
}

