/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSApplyCallType
extends JSSimpleTypeBaseImpl {
    @NotNull
    private final JSType myType;

    public JSApplyCallType(@NotNull JSType baseType, @NotNull JSTypeSource source) {
        if (baseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "<init>"));
        }
        super(source);
        this.myType = baseType;
    }

    @NotNull
    public JSType getBaseType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "getBaseType"));
        }
        return jSType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "#call(" + this.myType.getTypeText(format) + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "getTypeText"));
            }
            return string;
        }
        String string = JSAnyType.get((PsiElement)this.getScope(), false).getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "getTypeText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "copyWithNewSource"));
        }
        JSApplyCallType jSApplyCallType = new JSApplyCallType(this.myType, source);
        if (jSApplyCallType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "copyWithNewSource"));
        }
        return jSApplyCallType;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSApplyCallType", "isEquivalentToImpl"));
        }
        return type instanceof JSApplyCallType && this.myType.isEquivalentTo(((JSApplyCallType)type).myType, context, allowResolve);
    }
}

