/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeCastUtil {
    private static final Key<Map<Object, Set<Object>>> OUR_ALREADY_COMPARED_TYPES_KEY = Key.create((String)"already.compared.types");

    public static boolean startRecursiveTypesComparison(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        String lId = JSTypeCastUtil.getTypeIdForComparison(type1);
        String rId = JSTypeCastUtil.getTypeIdForComparison(type2);
        return JSTypeCastUtil.startRecursiveTypesComparison(lId, rId, processingContext);
    }

    @NotNull
    public static String getTypeIdForComparison(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeIdForComparison"));
        }
        if (type instanceof JSNamedType) {
            String string = JSTypeCastUtil.getTypeStringForComparison((JSNamedType)type);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeIdForComparison"));
            }
            return string;
        }
        if (type instanceof JSRecordType) {
            String string = "#record#" + type.hashCode();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeIdForComparison"));
            }
            return string;
        }
        if (type instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            String separator = ((JSCompositeTypeImpl)type).getTypeSeparator();
            String string = "#composite#" + StringUtil.join(types, el -> JSTypeCastUtil.getTypeIdForComparison(el), (String)separator);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeIdForComparison"));
            }
            return string;
        }
        String string = "#type#" + type.getClass() + "#" + type.hashCode();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeIdForComparison"));
        }
        return string;
    }

    public static void endRecursiveTypesComparison(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        String type1Id = JSTypeCastUtil.getTypeIdForComparison(type1);
        String type2Id = JSTypeCastUtil.getTypeIdForComparison(type2);
        JSTypeCastUtil.endRecursiveTypesComparison(type1Id, type2Id, processingContext);
    }

    @NotNull
    private static String getTypeStringForComparison(JSNamedType type1) {
        String string = (JSTypeContext.STATIC == type1.getTypeContext() ? "static#" : "") + type1.getResolvedTypeText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeStringForComparison"));
        }
        return string;
    }

    public static boolean startRecursiveTypesComparison(@Nullable Object thisTypeId, @Nullable Object elementTypeId, @NotNull ProcessingContext processingContext) {
        Set typesComparedToThis;
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        ProgressIndicatorProvider.checkCanceled();
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new THashMap();
            processingContext.put(OUR_ALREADY_COMPARED_TYPES_KEY, (Object)alreadyComparedTypes);
        }
        if ((typesComparedToThis = (Set)alreadyComparedTypes.get(thisTypeId)) == null) {
            THashSet set = new THashSet();
            set.add(elementTypeId);
            alreadyComparedTypes.put(thisTypeId, set);
            return true;
        }
        return typesComparedToThis.add(elementTypeId);
    }

    public static void endRecursiveTypesComparison(Object thisTypeId, Object elementTypeId, @NotNull ProcessingContext processingContext) {
        Set elementQNames;
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes != null && (elementQNames = (Set)alreadyComparedTypes.get(thisTypeId)) != null) {
            elementQNames.remove(elementTypeId);
            if (elementQNames.isEmpty()) {
                alreadyComparedTypes.remove(thisTypeId);
            }
        }
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @NotNull JSType rOperand, @Nullable ProcessingContext processingContext) {
        JSType substitutedType;
        JSType type;
        if (thisOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisOperand", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
        }
        if (rOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOperand", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
        }
        if (rOperand instanceof JSUndefinedType) {
            AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            JSType type2 = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (type2 != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type2, processingContext));
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(rOperand.isDirectlyAssignableType(thisOperand, processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSUnionOrIntersectionType) {
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)rOperand;
            boolean isIntersection = compositeType instanceof JSIntersectionTypeImpl;
            boolean isStrictContext = JSTypeCastUtil.isStrictTypeScriptType(compositeType);
            boolean result = JSTypeCastUtil.checkAssignableComposite(thisOperand, compositeType, processingContext, !isIntersection && isStrictContext);
            if (result || !isStrictContext) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result);
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if ((typedefValue = jsType.getTypedef(null, processingContext)) != null) {
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand, jsType, processingContext)) {
                    AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                    }
                    return assignableResult;
                }
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)rOperand).getType()) instanceof JSTypeImpl && ((JSTypeImpl)type).getTypedef(null, processingContext) != null && (substitutedType = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if ((rOperand instanceof JSIterableComponentTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl || rOperand instanceof TypeScriptTypePredicateTypeImpl || rOperand instanceof JSEvaluableType || rOperand instanceof TypeScriptTypeOperatorJSTypeImpl || rOperand instanceof TypeScriptIndexedAccessJSTypeImpl || rOperand instanceof TypeScriptMappedJSTypeImpl || rOperand instanceof JSCompositeTypeBaseImpl) && (type = rOperand.substitute()) != rOperand) {
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand, rOperand, processingContext)) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            AssignableResult result = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            JSTypeCastUtil.endRecursiveTypesComparison(thisOperand, rOperand, processingContext);
            AssignableResult assignableResult = result;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        AssignableResult assignableResult = thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isAlwaysAssignableType"));
        }
        if (type instanceof JSAnyType || type instanceof TypeScriptNeverType || type instanceof JSRequireCallExpressionType) {
            return true;
        }
        return (type instanceof JSNullType || type instanceof JSUndefinedType) && !((JSSimpleTypeBaseImpl)type).isJavaScript();
    }

    public static boolean isStrictTypeScriptType(@NotNull JSUnionOrIntersectionType rOperand) {
        if (rOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOperand", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isStrictTypeScriptType"));
        }
        assert (rOperand instanceof JSTypeBaseImpl);
        JSTypeBaseImpl baseType = (JSTypeBaseImpl)((Object)rOperand);
        return baseType.isTypeScript() && baseType.isExplicitlyDeclared();
    }

    public static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type) {
        TypeScriptTypeParameterListOwner owner;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "buildWithAppliedGenericArguments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "buildWithAppliedGenericArguments"));
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && ((owner = (TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList() != null || type.getOuterArguments() != null)) {
            JSTypeSubstitutor genericArgumentsMap = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
            JSType baseType = type.getType();
            boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
            JSRecordType recordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
            return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)recordType, (Map<String, JSType>)genericArgumentsMap);
        }
        return null;
    }

    public static boolean checkAssignableComposite(@NotNull JSType thisOperand, @NotNull JSUnionOrIntersectionType rOperand, @Nullable ProcessingContext processingContext, boolean needCheckAllTypes) {
        if (thisOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisOperand", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "checkAssignableComposite"));
        }
        if (rOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOperand", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "checkAssignableComposite"));
        }
        for (JSType jsType : rOperand.getTypes()) {
            boolean result = thisOperand.isDirectlyAssignableType(jsType, processingContext);
            if (needCheckAllTypes) {
                if (result) continue;
                return false;
            }
            if (!result) continue;
            return true;
        }
        return needCheckAllTypes;
    }

    public static enum AssignableResult {
        ASSIGNABLE(true, true),
        NOT_ASSIGNABLE(true, false),
        NOT_SURE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }
    }
}

