/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSClassMemberReferencesVisitor;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSPullUpConflictsUtil {
    public static MultiMap<PsiElement, String> checkConflicts(JSMemberInfo[] infos, JSClass subclass, JSClass superClass, JSInterfaceContainmentVerifier interfaceContainmentVerifier, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpConflictsUtil", "checkConflicts"));
        }
        MultiMap conflicts = new MultiMap();
        JSRefactoringConflictsUtil.checkIncomingReferencesAccessibility(JSRefactoringUtil.getUsages(JSMemberInfo.getStatics(infos), superClass), superClass, "escalate", (MultiMap<PsiElement, String>)conflicts, options);
        JSRefactoringConflictsUtil.checkMembersAlreadyExist(infos, superClass, (MultiMap<PsiElement, String>)conflicts);
        if (superClass.isInterface()) {
            JSPullUpConflictsUtil.checkNoFieldsInInterface(infos, (MultiMap<PsiElement, String>)conflicts);
        }
        HashSet<JSAttributeListOwner> membersToMove = new HashSet<JSAttributeListOwner>();
        HashSet<JSFunction> methodsToAbstract = new HashSet<JSFunction>();
        for (JSMemberInfo info : infos) {
            JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
            if (member instanceof JSFunction && superClass.isInterface()) {
                methodsToAbstract.add((JSFunction)member);
                continue;
            }
            membersToMove.add(member);
        }
        for (JSAttributeListOwner member : membersToMove) {
            if (member instanceof JSClass) {
                if (JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, null, (PsiElement)superClass, JSVisibilityUtil.DEFAULT_OPTIONS)) continue;
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)member, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE), JSFormatUtil.formatVisibility(member.getAttributeList().getAccessType()), ElementDescriptionUtil.getElementDescription((PsiElement)superClass, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)subclass, (Object)message);
                continue;
            }
            NonAccessibleUsagesOfSubClassMembers visitor = new NonAccessibleUsagesOfSubClassMembers((PsiElement)member, membersToMove, methodsToAbstract, subclass, superClass, (MultiMap<PsiElement, String>)conflicts, interfaceContainmentVerifier);
            member.accept((PsiElementVisitor)visitor);
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)member, membersToMove, (PsiElement)superClass, true, (MultiMap<PsiElement, String>)conflicts, (Condition<PsiElement>)((Condition)element -> !JSInheritanceUtil.isMemberOfSubclass(superClass, (JSElement)element, true)), options);
        }
        for (JSFunction member : methodsToAbstract) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesInSignatureAccessibility(member, (PsiElement)superClass, true, (MultiMap<PsiElement, String>)conflicts, options);
        }
        ArrayList<Object> checkModuleConflictsFor = new ArrayList<Object>(membersToMove);
        for (JSFunction method : methodsToAbstract) {
            checkModuleConflictsFor.add(method.getParameterList());
            PsiElement element2 = method.getReturnTypeElement();
            if (element2 == null) continue;
            checkModuleConflictsFor.add(element2);
        }
        JSRefactoringConflictsUtil.analyzeModuleConflicts(subclass.getProject(), checkModuleConflictsFor, UsageInfo.EMPTY_ARRAY, (PsiElement)superClass, (MultiMap<PsiElement, String>)conflicts);
        return conflicts;
    }

    private static void checkNoFieldsInInterface(JSMemberInfo[] infos, MultiMap<PsiElement, String> conflicts) {
        for (JSMemberInfo info : infos) {
            PsiElement member = info.getMember();
            if (!(member instanceof JSVariable)) continue;
            String message = JSBundle.message((String)"0.is.not.allowed.in.interface", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
        }
    }

    private static class NonAccessibleUsagesOfSubClassMembers
    extends JSClassMemberReferencesVisitor {
        private final PsiElement myScope;
        private final Set<JSAttributeListOwner> myMovedMembers;
        private final Set<JSFunction> myAbstractMethods;
        private final JSClass mySuperClass;
        private final MultiMap<PsiElement, String> myConflictsList;
        private final JSInterfaceContainmentVerifier myInterfaceContainmentVerifier;

        NonAccessibleUsagesOfSubClassMembers(PsiElement scope, Set<JSAttributeListOwner> movedMembers, Set<JSFunction> abstractMethods, JSClass subclass, JSClass superClass, MultiMap<PsiElement, String> conflictsList, JSInterfaceContainmentVerifier interfaceContainmentVerifier) {
            super(subclass);
            this.myScope = scope;
            this.myMovedMembers = movedMembers;
            this.myAbstractMethods = abstractMethods;
            this.mySuperClass = superClass;
            this.myConflictsList = conflictsList;
            this.myInterfaceContainmentVerifier = interfaceContainmentVerifier;
        }

        @Override
        protected void visitMemberReference(JSAttributeListOwner classMember, JSReferenceExpression classMemberReference) {
            String message = null;
            if (classMember.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC) && !this.willBeMoved((PsiElement)classMember)) {
                boolean isAccessible;
                if (this.mySuperClass != null) {
                    isAccessible = JSVisibilityUtil.isAccessible((PsiElement)classMember, (JSAttributeList)null, null, (PsiElement)this.mySuperClass, JSVisibilityUtil.DEFAULT_OPTIONS);
                } else {
                    boolean bl = isAccessible = classMember.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC;
                }
                if (!isAccessible) {
                    message = CommonRefactoringUtil.capitalize((String)RefactoringBundle.message((String)"0.uses.1.which.is.not.accessible.from.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)}));
                }
            } else if (!(this.myAbstractMethods.contains(classMember) || this.willBeMoved((PsiElement)classMember) || this.existsInSuperClass((JSElement)classMember))) {
                message = CommonRefactoringUtil.capitalize((String)RefactoringBundle.message((String)"0.uses.1.which.is.not.moved.to.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)}));
            }
            if (message != null) {
                this.myConflictsList.putValue((Object)classMember, message);
            }
        }

        private boolean willBeMoved(PsiElement element) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!this.myMovedMembers.contains(parent)) continue;
                return true;
            }
            return false;
        }

        private boolean existsInSuperClass(JSElement classMember) {
            if (!(classMember instanceof JSFunction)) {
                return false;
            }
            JSFunction method = (JSFunction)classMember;
            if (this.myInterfaceContainmentVerifier.checkedInterfacesContain(method)) {
                return true;
            }
            if (this.mySuperClass == null) {
                return false;
            }
            return this.mySuperClass.findFunctionByName(method.getName()) != null;
        }
    }
}

