/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceQueueImpl
implements JSLanguageServiceQueue {
    public static final String CANNOT_START_LANGUAGE_SERVICE_PROCESS = "Cannot start language service process";
    public static final String TIMEOUT_ON_STARTING_SERVICE_PROCESS = "Timeout on starting language service process";
    public static final String CAN_NOT_GET_RESULT_FROM_LANGUAGE_SERVICE = "Can not get result from language service";
    public static final String LANGUAGE_SERVICE_EXECUTION_TIMEOUT = "Language service execution timeout";
    @NotNull
    private final Object myLock;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;
    @NotNull
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    @NotNull
    private final JSLanguageServiceProtocol myProtocol;
    @NotNull
    private final Project myProject;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @NotNull
    private volatile JSLanguageServiceQueue.State myState;
    @Nullable
    private volatile BackgroundableProcessIndicator myIndicator;
    private volatile String myStartErrorMessage;
    private volatile boolean myDisposed;
    @Nullable
    private ProcessHandler myProcessHandler;

    public JSLanguageServiceQueueImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter, @NotNull JSLanguageServiceCacheData cacheData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "<init>"));
        }
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "<init>"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "<init>"));
        }
        if (cacheData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheData", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "<init>"));
        }
        this.myLock = new Object();
        this.myState = JSLanguageServiceQueue.State.STARTING;
        this.myDisposed = false;
        this.myReporter = reporter;
        LowMemoryWatcher.register(this::resetCaches, (Disposable)this);
        this.myCacheData = cacheData;
        this.myProject = project;
        this.myProcessConnector = connector;
        this.myProtocol = protocol;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("JS external service " + reporter.getServiceName()));
        Disposer.register((Disposable)project, (Disposable)this);
        this.init();
    }

    @Override
    @NotNull
    public final JSLanguageServiceQueue.State getState() {
        JSLanguageServiceQueue.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "getState"));
        }
        return state;
    }

    private void init() {
        LOGGER.debug("Submit init action to thread pool");
        this.myExecutorService.submit(() -> {
            BackgroundableProcessIndicator indicator = this.createIndicator();
            Object object = this.myLock;
            synchronized (object) {
                if (this.getState() == JSLanguageServiceQueue.State.DISPOSED && indicator != null) {
                    JSLanguageServiceQueueImpl.disposeIndicator(indicator);
                } else {
                    this.myIndicator = indicator;
                }
            }
            if (indicator != null && !indicator.isCanceled()) {
                indicator.start();
            }
            try {
                LOGGER.debug("Start service in thread pool");
                this.startService();
                object = this.myLock;
                synchronized (object) {
                    if (LOGGER.isDebugEnabled() && this.myProcessHandler != null) {
                        LOGGER.debug("Language service successfully started");
                    }
                }
            }
            catch (Throwable e) {
                this.myStartErrorMessage = JSLanguageServiceQueueImpl.getExceptionMessage(e);
                LOGGER.info("Exception on starting language service", e);
            }
            finally {
                this.createUI();
            }
        });
        this.myExecutorService.submit(() -> {
            try {
                ProcessHandler processHandler;
                Object object = this.myLock;
                synchronized (object) {
                    processHandler = this.myProcessHandler;
                }
                if (processHandler != null && this.getState() == JSLanguageServiceQueue.State.STARTING) {
                    if (this.myProtocol.awaitReadyNotification(processHandler)) {
                        this.myState = JSLanguageServiceQueue.State.STARTED;
                    } else {
                        this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                        if (this.myStartErrorMessage == null) {
                            this.myStartErrorMessage = this.myProtocol.getInitializeError();
                        }
                        String errorText = this.myStartErrorMessage == null ? TIMEOUT_ON_STARTING_SERVICE_PROCESS : this.myStartErrorMessage;
                        UIUtil.invokeLaterIfNeeded(() -> this.myReporter.logError(errorText));
                        this.stop(false);
                    }
                }
            }
            catch (Throwable e) {
                this.myStartErrorMessage = JSLanguageServiceQueueImpl.getExceptionMessage(e);
                LOGGER.info("Exception on starting language service", e);
            }
            finally {
                BackgroundableProcessIndicator indicator = this.myIndicator;
                if (indicator != null) {
                    indicator.processFinish();
                    JSLanguageServiceQueueImpl.disposeIndicator(indicator);
                }
            }
        });
    }

    private BackgroundableProcessIndicator createIndicator() {
        if (this.myProcessConnector == null) {
            return null;
        }
        return (BackgroundableProcessIndicator)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed() || !this.myProject.isOpen() || !this.isValid()) {
                return null;
            }
            return new BackgroundableProcessIndicator(this.myProject, "Starting " + this.myReporter.getServiceName() + " Service", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false);
        });
    }

    private void createUI() {
        ReadAction.run(() -> StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            ProcessHandler handler;
            Object object = this.myLock;
            synchronized (object) {
                handler = this.myProcessHandler;
                if (this.myProject.isDisposed() || this.myDisposed) {
                    return;
                }
            }
            if (handler == null || !this.isValid()) {
                String errorText = this.myStartErrorMessage == null ? CANNOT_START_LANGUAGE_SERVICE_PROCESS : this.myStartErrorMessage;
                this.myReporter.logError(errorText);
            } else if (this.myProcessConnector != null) {
                this.myProcessConnector.connectToProcessHandler(handler);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startService() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                LOGGER.debug("Creating OS Handler");
                this.myProcessHandler = this.myProtocol.connect();
                if (this.myProcessHandler == null) {
                    this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                    this.myStartErrorMessage = this.myProtocol.getInitializeError();
                    return;
                }
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDERR) {
                            JSLanguageServiceQueue.LOGGER.debug("Stderr output: " + event.getText());
                            return;
                        }
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            JSLanguageServiceQueue.LOGGER.trace("Stdout output: " + event.getText());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        if (JSLanguageServiceQueueImpl.this.myState == JSLanguageServiceQueue.State.STARTED || JSLanguageServiceQueueImpl.this.myState == JSLanguageServiceQueue.State.STARTING) {
                            JSLanguageServiceQueueImpl.this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                        }
                        JSLanguageServiceQueue.LOGGER.trace("Process was killed " + event.getText());
                    }
                });
                LOGGER.debug("OS Handler created successfully");
            }
            catch (Exception e) {
                this.myState = JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
                this.myStartErrorMessage = JSLanguageServiceQueueImpl.getExceptionMessage(e);
                LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.myProcessHandler != null && this.myState == JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT) {
                    this.stop(false);
                }
            }
        }
    }

    private static String getExceptionMessage(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "getExceptionMessage"));
        }
        return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
    }

    public final void dispose() {
        this.myDisposed = true;
        this.stop(true);
    }

    @Override
    @Nullable
    public final <T> Future<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand<T> input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeWithCache"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeWithCache"));
        }
        try {
            return this.myExecutorService.submit(() -> {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "lambda$executeWithCache$7"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "lambda$executeWithCache$7"));
                }
                if (this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeWithCacheImpl(input, processor);
                    return t;
                }
                catch (Throwable err) {
                    LOGGER.error(err.getMessage(), err);
                }
                finally {
                    this.endAction();
                }
                return null;
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    private <T> T executeWithCacheImpl(@NotNull JSLanguageServiceCacheableCommand<T> input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeWithCacheImpl"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeWithCacheImpl"));
        }
        long startTime = System.currentTimeMillis();
        T valueFromCache = this.myCacheData.getValueFromCache(input);
        if (valueFromCache != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Used service cache " + input);
            }
            return processor.processFromCache(input, valueFromCache);
        }
        JSLanguageServiceObject objectToSend = this.myCacheData.updateCacheAndGetServiceObject(input);
        if (objectToSend == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skip processing: " + input);
            }
            return null;
        }
        this.startAction(input);
        JSLanguageServiceAnswer answer = this.await(input, objectToSend);
        if (answer == null || answer.isEmpty() || this.myState != JSLanguageServiceQueue.State.STARTED) {
            LOGGER.debug("There is no result");
            this.myCacheData.putCacheValue(input, answer, null);
            return null;
        }
        T result = processor.process(input, objectToSend, answer);
        this.myCacheData.putCacheValue(input, answer, result);
        if (LOGGER.isDebugEnabled()) {
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.debug("Total process queue command " + input.getCommand() + " time, millis: " + totalTime);
        }
        return result;
    }

    @Override
    @Nullable
    public final <T> Future<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "execute"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "execute"));
        }
        try {
            return this.myExecutorService.submit(() -> {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "lambda$execute$8"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "lambda$execute$8"));
                }
                if (this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeImpl(command, processor);
                    return t;
                }
                finally {
                    this.endAction();
                }
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public <T> T executeImpl(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeImpl"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeImpl"));
        }
        long startTime = System.currentTimeMillis();
        JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (serviceObject == null) {
            return null;
        }
        this.startAction(command);
        JSLanguageServiceAnswer answer = this.await(command, serviceObject);
        if (this.myState != JSLanguageServiceQueue.State.STARTED) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        T process = processor.process(serviceObject, answer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Total process queue " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
        }
        return process;
    }

    @Override
    public final void executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<JSLanguageServiceAnswer> consumer) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeNoBlocking"));
        }
        try {
            this.myExecutorService.submit(() -> {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "lambda$executeNoBlocking$9"));
                }
                if (this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return;
                }
                this.startAction(command);
                try {
                    this.executeNoBlockingImpl(command, consumer);
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOGGER.error(throwable.getMessage(), throwable);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
        }
    }

    private void executeNoBlockingImpl(final @NotNull JSLanguageServiceCommand command, final @Nullable Consumer<JSLanguageServiceAnswer> consumer) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "executeNoBlockingImpl"));
        }
        final long startTime = System.currentTimeMillis();
        JSLanguageServiceObject data = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (data == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Send data for: " + command.getCommand());
        }
        this.sendData(command, data, consumer == null ? null : new JSLanguageServiceAnswerConsumer(){

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (JSLanguageServiceQueueImpl.this.myState != JSLanguageServiceQueue.State.STARTED) {
                    return;
                }
                JSLanguageServiceQueueImpl.this.endAction();
                if (message != null) {
                    consumer.consume((Object)message);
                    if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                        long processingTime = System.currentTimeMillis() - startTime;
                        JSLanguageServiceQueue.LOGGER.debug("Total process queue non-blocking command " + command.getCommand() + " time, millis: " + processingTime);
                    }
                }
            }
        });
    }

    @Nullable
    private JSLanguageServiceAnswer await(JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "await"));
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start await \"" + command.getCommand() + "\"");
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference ref = new AtomicReference();
            Object cancellationToken = this.sendData(command, data, new JSLanguageServiceAnswerConsumer(){

                @Override
                public void consume(JSLanguageServiceAnswer message) {
                    ref.set(message);
                    latch.countDown();
                }
            });
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                this.myProtocol.cancelCommand(cancellationToken);
                LOGGER.warn("JavaScript Language Service: IDE-side timeout waiting answer for " + command.getCommand());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Language Service answer was received: " + command.getCommand());
            }
            return (JSLanguageServiceAnswer)ref.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            LOGGER.error(err.getMessage(), err);
        }
        return null;
    }

    private Object sendData(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer consumer) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "sendData"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "sendData"));
        }
        return this.myProtocol.sendCommand(command, data, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean awaitPoolTermination) {
        boolean inTest = ApplicationManager.getApplication().isUnitTestMode();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState == JSLanguageServiceQueue.State.DISPOSED) {
                return;
            }
            this.myState = JSLanguageServiceQueue.State.DISPOSED;
            JSLanguageServiceQueueImpl.disposeIndicator(this.myIndicator);
            this.myExecutorService.shutdown();
            if (!inTest) {
                this.myExecutorService.shutdownNow();
                try {
                    this.myExecutorService.awaitTermination(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Disposer.dispose((Disposable)this.myCacheData);
            Disposer.dispose((Disposable)this.myProtocol);
            this.resetCaches();
            if (this.myProcessHandler != null) {
                if (!this.myProcessHandler.isProcessTerminated() && !this.myProcessHandler.isProcessTerminating()) {
                    this.myProcessHandler.destroyProcess();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProcessConnector != null) {
                        this.myProcessConnector.disconnectFromProcessHandler();
                    }
                });
            }
        }
        if (awaitPoolTermination && inTest) {
            this.shutdownAndAwaitTermination(this.myExecutorService);
        }
    }

    void shutdownAndAwaitTermination(@NotNull ExecutorService pool) {
        if (pool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pool", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "shutdownAndAwaitTermination"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(3L, TimeUnit.MINUTES)) {
                    LOGGER.warn("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void startAction(@NotNull JSLanguageServiceCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl", "startAction"));
        }
        String text = command.getPresentableText(this.myProject);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    private void endAction() {
        if (this.getState() == JSLanguageServiceQueue.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private static void disposeIndicator(@Nullable BackgroundableProcessIndicator indicator) {
        try {
            if (indicator != null) {
                if (!indicator.isCanceled()) {
                    indicator.cancel();
                }
                Disposer.dispose((Disposable)indicator);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceQueue.State state = this.myState;
        return state != JSLanguageServiceQueue.State.DISPOSED && state != JSLanguageServiceQueue.State.ERROR_OR_TIMEOUT;
    }

    @Override
    public String getStartErrorMessage() {
        return this.myStartErrorMessage;
    }
}

