/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptConfigImpl
extends TypeScriptConfigBase {
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Map<String, String> myOptions;
    @NotNull
    private final VirtualFile myConfigDirectory;
    @NotNull
    private final Collection<VirtualFile> myFilesList;
    @NotNull
    private final Collection<String> myExcludePatterns;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    @NotNull
    private final TypeScriptConfig.LanguageTarget myLanguageTarget;
    private final boolean myHasFilesList;
    private final boolean myHasIncludeList;
    private final boolean myHasExcludeList;
    @NotNull
    private final Collection<String> myRootDirs;
    @NotNull
    private final Collection<JSModulePathSubstitution> myPaths;
    @Nullable
    private final String myBaseUrl;
    private final boolean myCompileOnSave;
    private final boolean myInlineSourceMap;
    private final boolean mySourceMap;
    private final String myExtendsPath;
    @NotNull
    private final Project myProject;
    private final boolean myHasErrors;
    private final boolean myDirectoryBased;
    @Nullable
    private final String myModuleResolution;
    @Nullable
    private final String myModule;
    private final NotNullLazyValue<Boolean> myHasES6Libs;
    @NotNull
    private final Collection<String> myTypeRoots;
    private final Collection<String> myLibs;
    @NotNull
    private final Collection<String> myTypes;
    private final NotNullLazyValue<Collection<VirtualFile>> myTypeRootFiles;
    private final NullableLazyValue<VirtualFile> myBaseUrlFile;
    private final NotNullLazyValue<Collection<PsiFileSystemItem>> myRootDirPsiElements;
    private final NotNullLazyValue<Collection<VirtualFile>> myRootDirFiles;
    private final NullableLazyValue<Pattern> myExcludeRegPattern;
    private final NullableLazyValue<Pattern> myIncludeFilesRegPattern;
    private final NullableLazyValue<Pattern> myIncludeDirectoriesRegPattern;

    @Nullable
    static TypeScriptConfigImpl getSimpleConfigImpl(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getSimpleConfigImpl"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!(rawFile instanceof JsonFile)) {
            return null;
        }
        Project project = rawFile.getProject();
        JsonFile file = (JsonFile)rawFile;
        VirtualFile configVirtualFile = rawFile.getVirtualFile();
        VirtualFile configFile = file.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDirectory = configFile.getParent();
        if (configDirectory == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        boolean hasErrors = PsiTreeUtil.hasErrorElements((PsiElement)file);
        return jsonObject == null ? new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, hasErrors) : new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, jsonObject, hasErrors);
    }

    @Nullable
    VirtualFile getExtendsParent() {
        if (StringUtil.isEmpty((String)this.myExtendsPath)) {
            return null;
        }
        String text = StringUtil.endsWithIgnoreCase((String)this.myExtendsPath, (String)".json") ? this.myExtendsPath : this.myExtendsPath + ".json";
        return JSPathMappingsUtil.getPathRelativeBaseUrl(this.getConfigDirectory(), text);
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(@Nullable JsonProperty filesProperty) {
        if (filesProperty == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
            }
            return list;
        }
        JsonValue value = filesProperty.getValue();
        if (value == null || !(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
            }
            return list;
        }
        HashSet files = ContainerUtil.newHashSet();
        JsonArray arrayWithFiles = (JsonArray)value;
        for (JsonValue jsonValue : arrayWithFiles.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            for (PsiReference reference : jsonValue.getReferences()) {
                PsiElement resolve;
                if (reference instanceof FileReference && !((FileReference)reference).isLast() || !((resolve = reference.resolve()) instanceof PsiFileSystemItem)) continue;
                files.add(((PsiFileSystemItem)resolve).getVirtualFile());
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, String> getCompilerOptions(@Nullable JsonValue value) {
        HashMap result = ContainerUtil.newHashMap();
        if (!(value instanceof JsonObject)) {
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
            }
            return hashMap;
        }
        JsonObject jsonObject = (JsonObject)value;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            String optionName = property.getName();
            JsonValue optionValue = property.getValue();
            if (optionValue == null) continue;
            result.put(StringUtil.unquoteString((String)optionName), optionValue.getText());
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
        }
        return hashMap;
    }

    @Nullable
    private Pattern createPattern(@Nullable String pattern) {
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern, this.isCaseSensitive() ? 0 : 2);
    }

    private boolean isCaseSensitive() {
        VirtualFileSystem fs = this.getConfigDirectory().getFileSystem();
        return fs.isCaseSensitive();
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, boolean hasErrors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDirectory", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        this.myHasES6Libs = new NotNullLazyValue<Boolean>(){

            @NotNull
            protected Boolean compute() {
                for (String lib : TypeScriptConfigImpl.this.myLibs) {
                    int parsedValue;
                    String index;
                    block8: {
                        Boolean bl;
                        if (!StringUtil.toLowerCase((String)lib).startsWith("es")) continue;
                        int indexOfEnd = lib.indexOf(".");
                        if (indexOfEnd == -1) {
                            indexOfEnd = lib.length();
                        }
                        try {
                            index = lib.substring(2, indexOfEnd);
                            parsedValue = Integer.parseInt(index);
                            if (index.length() != 1 || parsedValue < 6) break block8;
                            bl = true;
                        }
                        catch (Exception e) {
                            Logger.getInstance(TypeScriptConfigImpl.class).debug((Throwable)e);
                            continue;
                        }
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
                        }
                        return bl;
                    }
                    if (index.length() != 4 || parsedValue < 2015) continue;
                    Boolean bl = true;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
                    }
                    return bl;
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
                }
                return bl;
            }
        };
        this.myTypeRootFiles = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                if (TypeScriptConfigImpl.this.myTypeRoots.isEmpty()) {
                    VirtualFile defaultTypesDirectory = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath("node_modules/@types", TypeScriptConfigImpl.this.getConfigDirectory());
                    if (defaultTypesDirectory == null) {
                        List list = ContainerUtil.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$2", "compute"));
                        }
                        return list;
                    }
                    List list = ContainerUtil.createMaybeSingletonList((Object)defaultTypesDirectory);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$2", "compute"));
                    }
                    return list;
                }
                ArrayList results = ContainerUtil.newArrayList();
                for (String root : TypeScriptConfigImpl.this.myTypeRoots) {
                    VirtualFile path;
                    if (StringUtil.isEmpty((String)root) || (path = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(root, TypeScriptConfigImpl.this.getConfigDirectory())) == null) continue;
                    results.add(path);
                }
                ArrayList arrayList = results;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$2", "compute"));
                }
                return arrayList;
            }
        };
        this.myBaseUrlFile = new NullableLazyValue<VirtualFile>(){

            protected VirtualFile compute() {
                if (TypeScriptConfigImpl.this.myBaseUrl == null) {
                    return null;
                }
                return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(TypeScriptConfigImpl.this.myBaseUrl, TypeScriptConfigImpl.this.getConfigDirectory());
            }
        };
        this.myRootDirPsiElements = new NotNullLazyValue<Collection<PsiFileSystemItem>>(){

            @NotNull
            protected Collection<PsiFileSystemItem> compute() {
                if (TypeScriptConfigImpl.this.myRootDirs.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$4", "compute"));
                    }
                    return list;
                }
                List list = ContainerUtil.mapNotNull((Collection)TypeScriptConfigImpl.this.myRootDirs, filePath -> {
                    VirtualFile path = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(filePath, TypeScriptConfigImpl.this.getConfigDirectory());
                    if (path != null) {
                        return PsiManager.getInstance((Project)TypeScriptConfigImpl.this.myProject).findDirectory(path);
                    }
                    return null;
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$4", "compute"));
                }
                return list;
            }
        };
        this.myRootDirFiles = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                Collection dirs = (Collection)TypeScriptConfigImpl.this.myRootDirPsiElements.getValue();
                List list = ContainerUtil.map((Collection)dirs, PsiFileSystemItem::getVirtualFile);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$5", "compute"));
                }
                return list;
            }
        };
        this.myExcludeRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (TypeScriptConfigImpl.this.myExcludePatterns.isEmpty()) {
                    return null;
                }
                String wildcard = TypeScriptConfigUtil.getRegularExpressionForGlobPattern(TypeScriptConfigImpl.this.myExcludePatterns, TypeScriptConfigImpl.this.getConfigDirectory(), TypeScriptConfigUtil.WildCardType.EXCLUDE);
                return TypeScriptConfigImpl.this.createPattern(wildcard);
            }
        };
        this.myIncludeFilesRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (TypeScriptConfigImpl.this.myIncludedPatterns.isEmpty()) {
                    return null;
                }
                String wildcard = TypeScriptConfigUtil.getRegularExpressionForGlobPattern(TypeScriptConfigImpl.this.myIncludedPatterns, TypeScriptConfigImpl.this.getConfigDirectory(), TypeScriptConfigUtil.WildCardType.FILES);
                return TypeScriptConfigImpl.this.createPattern(wildcard);
            }
        };
        this.myIncludeDirectoriesRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (TypeScriptConfigImpl.this.myIncludedPatterns.isEmpty()) {
                    return null;
                }
                String wildcard = TypeScriptConfigUtil.getRegularExpressionForGlobPattern(TypeScriptConfigImpl.this.myIncludedPatterns, TypeScriptConfigImpl.this.getConfigDirectory(), TypeScriptConfigUtil.WildCardType.DIRECTORIES);
                return TypeScriptConfigImpl.this.createPattern(wildcard);
            }
        };
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myOptions = ContainerUtil.newHashMap();
        this.myFilesList = ContainerUtil.emptyList();
        this.myIncludedPatterns = ContainerUtil.emptyList();
        this.myExcludePatterns = DEFAULT_EXCLUDE_VALUES;
        this.myLanguageTarget = DEFAULT_LANGUAGE_TARGET;
        this.myRootDirs = ContainerUtil.emptyList();
        this.myPaths = ContainerUtil.emptyList();
        this.myBaseUrl = null;
        this.myProject = project;
        this.myHasErrors = hasErrors;
        this.myDirectoryBased = true;
        this.myCompileOnSave = true;
        this.myInlineSourceMap = false;
        this.mySourceMap = false;
        this.myLibs = ContainerUtil.emptyList();
        this.myModuleResolution = null;
        this.myModule = null;
        this.myTypeRoots = ContainerUtil.emptyList();
        this.myTypes = ContainerUtil.emptyList();
        this.myExtendsPath = null;
        this.myHasFilesList = false;
        this.myHasIncludeList = false;
        this.myHasExcludeList = false;
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, @NotNull JsonObject jsonObject, boolean hasErrors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDirectory", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonObject", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        this.myHasES6Libs = new /* invalid duplicate definition of identical inner class */;
        this.myTypeRootFiles = new /* invalid duplicate definition of identical inner class */;
        this.myBaseUrlFile = new /* invalid duplicate definition of identical inner class */;
        this.myRootDirPsiElements = new /* invalid duplicate definition of identical inner class */;
        this.myRootDirFiles = new /* invalid duplicate definition of identical inner class */;
        this.myExcludeRegPattern = new /* invalid duplicate definition of identical inner class */;
        this.myIncludeFilesRegPattern = new /* invalid duplicate definition of identical inner class */;
        this.myIncludeDirectoriesRegPattern = new /* invalid duplicate definition of identical inner class */;
        JsonProperty compilerOptionsProperty = jsonObject.findProperty("compilerOptions");
        JsonValue compilerOptionsValue = compilerOptionsProperty == null ? null : compilerOptionsProperty.getValue();
        Map<String, String> options = TypeScriptConfigImpl.getCompilerOptions(compilerOptionsValue);
        JsonProperty filesProperty = jsonObject.findProperty("files");
        JsonProperty includeProperty = jsonObject.findProperty("include");
        JsonProperty excludeProperty = jsonObject.findProperty("exclude");
        this.myHasExcludeList = excludeProperty != null;
        this.myHasIncludeList = includeProperty != null;
        this.myHasFilesList = filesProperty != null;
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myProject = project;
        this.myOptions = options;
        this.myFilesList = TypeScriptConfigImpl.getFiles(filesProperty);
        this.myDirectoryBased = filesProperty == null && includeProperty == null;
        this.myExcludePatterns = excludeProperty != null ? TypeScriptConfigImpl.readValues(excludeProperty.getValue()) : DEFAULT_EXCLUDE_VALUES;
        this.myIncludedPatterns = includeProperty != null ? TypeScriptConfigImpl.readValues(includeProperty.getValue()) : ContainerUtil.emptyList();
        this.myRootDirs = TypeScriptConfigImpl.getRootDirs(compilerOptionsValue);
        this.myPaths = TypeScriptConfigImpl.getPaths(compilerOptionsValue);
        this.myBaseUrl = TypeScriptConfigImpl.getBaseUrl(compilerOptionsValue);
        this.myTypeRoots = TypeScriptConfigImpl.getTypeRoots(compilerOptionsValue);
        this.myTypes = TypeScriptConfigImpl.getTypes(compilerOptionsValue);
        this.myLibs = TypeScriptConfigImpl.getLibs(compilerOptionsValue);
        this.myModuleResolution = TypeScriptConfigImpl.getModuleResolution(compilerOptionsValue);
        this.myModule = TypeScriptConfigImpl.getModule(compilerOptionsValue);
        this.myHasErrors = hasErrors;
        this.myCompileOnSave = TypeScriptConfigImpl.getBooleanValue(jsonObject, "compileOnSave");
        this.myExtendsPath = TypeScriptConfigImpl.getStringOption((JsonElement)jsonObject, "extends");
        this.myInlineSourceMap = Boolean.parseBoolean(this.myOptions.get("inlineSourceMap"));
        this.mySourceMap = Boolean.parseBoolean(this.myOptions.get("sourceMap"));
        String optionValue = this.myOptions.get("target");
        this.myLanguageTarget = StringUtil.isEmpty((String)optionValue) ? DEFAULT_LANGUAGE_TARGET : TypeScriptConfigImpl.parseTarget(optionValue);
    }

    private static boolean getBooleanValue(@NotNull JsonObject jsonObject, String name) {
        if (jsonObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonObject", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getBooleanValue"));
        }
        JsonProperty compileOnSave = jsonObject.findProperty(name);
        JsonValue compileOnSaveValue = compileOnSave == null ? null : compileOnSave.getValue();
        return compileOnSaveValue == null ? true : Boolean.valueOf(compileOnSaveValue.getText());
    }

    public boolean hasFilesList() {
        return this.myHasFilesList;
    }

    public boolean hasIncludeList() {
        return this.myHasIncludeList;
    }

    public boolean hasExcludeList() {
        return this.myHasExcludeList;
    }

    @Override
    public boolean isFromFileList(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isFromFileList"));
        }
        return this.myFilesList.contains(file);
    }

    @Override
    public boolean isFromRootDirs(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isFromRootDirs"));
        }
        Collection virtualFiles = (Collection)this.myRootDirFiles.getValue();
        return !virtualFiles.isEmpty() && TypeScriptConfigImpl.containsFile(file, virtualFiles);
    }

    @Override
    @Nullable
    public String getRawCompilerOption(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getRawCompilerOption"));
        }
        return this.myOptions.get(name);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDependencies() {
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myConfigFile);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getDependencies"));
        }
        return list;
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isExcludedFile"));
        }
        String path = file.getCanonicalPath();
        if (this.myExcludePatterns.isEmpty() || path == null) {
            return false;
        }
        Pattern pattern = (Pattern)this.myExcludeRegPattern.getValue();
        if (pattern == null) {
            return false;
        }
        return TypeScriptConfigImpl.checkPattern(path, pattern);
    }

    @Override
    public boolean isIncludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isIncludedFile"));
        }
        return this.isIncludedFile(file, true);
    }

    @Override
    public boolean isIncludedFile(@NotNull VirtualFile file, boolean checkExclude) {
        Pattern filePattern;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isIncludedFile"));
        }
        if (this.myIncludedPatterns.isEmpty()) {
            return false;
        }
        String filePath = file.getCanonicalPath();
        if (filePath == null) {
            return false;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return false;
        }
        boolean skipCheckExclude = !checkExclude;
        String directoryPath = parent.getCanonicalPath();
        Pattern directoriesPattern = (Pattern)this.myIncludeDirectoriesRegPattern.getValue();
        return directoriesPattern != null ? directoryPath != null && TypeScriptConfigImpl.checkPattern(directoryPath, directoriesPattern) && ((filePattern = (Pattern)this.myIncludeFilesRegPattern.getValue()) != null ? TypeScriptConfigImpl.checkPattern(filePath, filePattern) && (skipCheckExclude || !this.isExcludedFile(file)) : skipCheckExclude || !this.isExcludedFile(file)) : (filePattern = (Pattern)this.myIncludeFilesRegPattern.getValue()) != null && TypeScriptConfigImpl.checkPattern(filePath, filePattern) && (skipCheckExclude || !this.isExcludedFile(file));
    }

    private static boolean containsFile(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> files) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "containsFile"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "containsFile"));
        }
        if (files.size() > 0) {
            for (VirtualFile includedFile : files) {
                if ((!includedFile.isDirectory() || !VfsUtilCore.isAncestor((VirtualFile)includedFile, (VirtualFile)file, (boolean)true)) && (includedFile.isDirectory() || !includedFile.equals(file))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getBaseUrl(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption((JsonElement)compilerOptions, "baseUrl");
    }

    private static String getModuleResolution(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption((JsonElement)compilerOptions, "moduleResolution");
    }

    private static String getModule(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption((JsonElement)compilerOptions, "module");
    }

    @Nullable
    private static String getStringOption(@Nullable JsonElement options, String name) {
        if (!(options instanceof JsonObject)) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)options;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            return null;
        }
        JsonValue value = property.getValue();
        return value instanceof JsonStringLiteral ? ((JsonStringLiteral)value).getValue() : null;
    }

    @NotNull
    private static Collection<String> getRootDirs(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "rootDirs");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getRootDirs"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTypes(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "types");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypes"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getLibs(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "lib");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getLibs"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTypeRoots(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "typeRoots");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypeRoots"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getPropertyList(@Nullable JsonValue compilerOptions, String name) {
        if (!(compilerOptions instanceof JsonObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
            }
            return list;
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
            }
            return list;
        }
        JsonValue value = property.getValue();
        Collection<String> collection = TypeScriptConfigImpl.readValues(value);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> readValues(JsonValue value) {
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "readValues"));
            }
            return list;
        }
        JsonArray jsonArray = (JsonArray)value;
        ArrayList resultList = ContainerUtil.newArrayList();
        for (JsonValue jsonValue : jsonArray.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            resultList.add(((JsonStringLiteral)jsonValue).getValue());
        }
        ArrayList arrayList = resultList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "readValues"));
        }
        return arrayList;
    }

    private static Collection<JSModulePathSubstitution> getPaths(@Nullable JsonValue compilerOptions) {
        if (!(compilerOptions instanceof JsonObject)) {
            return ContainerUtil.emptyList();
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty("paths");
        if (property == null) {
            return ContainerUtil.emptyList();
        }
        JsonValue propertyValue = property.getValue();
        if (!(propertyValue instanceof JsonObject)) {
            return ContainerUtil.emptyList();
        }
        JsonObject paths = (JsonObject)propertyValue;
        ArrayList result = ContainerUtil.newArrayList();
        for (JsonProperty jsonProperty : paths.getPropertyList()) {
            final String name = jsonProperty.getName();
            JsonValue value = jsonProperty.getValue();
            final ArrayList substitutions = ContainerUtil.newArrayList();
            if (value instanceof JsonStringLiteral) {
                substitutions.add(((JsonStringLiteral)value).getValue());
            } else if (value instanceof JsonArray) {
                for (JsonValue jsonValue : ((JsonArray)value).getValueList()) {
                    if (!(jsonValue instanceof JsonStringLiteral)) continue;
                    substitutions.add(((JsonStringLiteral)jsonValue).getValue());
                }
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)compilerOptions.getProject());
            final SmartPsiElementPointer pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsonProperty);
            result.add(new JSModulePathSubstitution(){

                @Override
                @NotNull
                public Collection<String> getMappings() {
                    Collection collection = substitutions;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$9", "getMappings"));
                    }
                    return collection;
                }

                @Override
                @NotNull
                public String getPattern() {
                    String string = name;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$9", "getPattern"));
                    }
                    return string;
                }

                @Override
                public boolean canStartWith() {
                    return false;
                }

                @Override
                public PsiElement getElement() {
                    return pointer.getElement();
                }
            });
        }
        return result;
    }

    @Override
    public boolean isDirectoryBased() {
        return this.myDirectoryBased;
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfigFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDirectory;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfigDirectory"));
        }
        return virtualFile;
    }

    @Override
    public boolean hasErrors() {
        return this.myHasErrors;
    }

    @Override
    @NotNull
    public Collection<JSModulePathSubstitution> getPaths() {
        Collection<JSModulePathSubstitution> collection = this.myPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPaths"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs() {
        Collection collection = (Collection)this.myRootDirPsiElements.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getRootDirs"));
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.LanguageTarget getLanguageTarget() {
        TypeScriptConfig.LanguageTarget languageTarget = this.myLanguageTarget;
        if (languageTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getLanguageTarget"));
        }
        return languageTarget;
    }

    @Override
    public boolean hasES6Lib() {
        return (Boolean)this.myHasES6Libs.getValue();
    }

    @Override
    public Collection<String> getLibNames() {
        return this.myLibs;
    }

    @Override
    @Nullable
    public VirtualFile getBaseUrl() {
        return (VirtualFile)this.myBaseUrlFile.getValue();
    }

    @Override
    @Nullable
    public String getOutDirectory() {
        VirtualFile baseDirectory = this.getConfigDirectory();
        String quotedString = this.myOptions.get("outDir");
        if (quotedString == null) {
            return null;
        }
        String directoryPath = StringUtil.unquoteString((String)quotedString);
        return TypeScriptConfigUtil.getOutDirectory(baseDirectory, directoryPath);
    }

    public String toString() {
        return "TypeScriptConfigImpl{myConfigFile=" + this.myConfigFile + ", myOptions=" + this.myOptions + ", myConfigDirectory=" + this.myConfigDirectory + ", myFilesList=" + this.myFilesList + '}';
    }

    public static TypeScriptConfig.LanguageTarget parseTarget(String value) {
        String lowerCaseValue = StringUtil.unquoteString((String)StringUtil.toLowerCase((String)value.trim()));
        if ("es3".equals(lowerCaseValue)) {
            return TypeScriptConfig.LanguageTarget.ES3;
        }
        if ("es6".equals(lowerCaseValue) || "es2015".equals(lowerCaseValue) || "es2016".equals(lowerCaseValue) || "es2017".equals(lowerCaseValue) || "es7".equals(lowerCaseValue) || "latest".equals(lowerCaseValue)) {
            return TypeScriptConfig.LanguageTarget.ES6;
        }
        return DEFAULT_LANGUAGE_TARGET;
    }

    @Override
    public boolean isCompileOnSave() {
        return this.myCompileOnSave;
    }

    @Override
    public boolean isInlineSourceMap() {
        return this.myInlineSourceMap;
    }

    @Override
    public boolean isSourceMap() {
        return this.mySourceMap;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getTypeRoots() {
        Collection collection = (Collection)this.myTypeRootFiles.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypeRoots"));
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.ModuleResolution getResolution() {
        TypeScriptConfig.ModuleResolution moduleResolution = "node".equals(this.myModuleResolution) ? TypeScriptConfig.ModuleResolution.NODE : TypeScriptConfig.ModuleResolution.OTHER;
        if (moduleResolution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getResolution"));
        }
        return moduleResolution;
    }

    @Override
    @NotNull
    public TypeScriptConfig.ModuleTarget getModule() {
        if (this.myModule == null) {
            TypeScriptConfig.ModuleTarget moduleTarget = TypeScriptConfig.ModuleTarget.COMMON_JS;
            if (moduleTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getModule"));
            }
            return moduleTarget;
        }
        TypeScriptConfig.ModuleTarget moduleTarget = StringUtil.equalsIgnoreCase((CharSequence)"commonjs", (CharSequence)this.myModule) ? TypeScriptConfig.ModuleTarget.COMMON_JS : TypeScriptConfig.ModuleTarget.OTHER;
        if (moduleTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getModule"));
        }
        return moduleTarget;
    }

    @Override
    @NotNull
    public Collection<String> getTypes() {
        Collection<String> collection = this.myTypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypes"));
        }
        return collection;
    }

    public boolean hasOption(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "hasOption"));
        }
        return this.myOptions.containsKey(name);
    }
}

