/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.intentions.TypeScriptLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TypeScriptConfigLibraryUpdater {
    private static final String LIBRARY_NAME = "tsconfig$roots";
    private static final int UPDATE_TIME = (int)TimeUnit.SECONDS.toMillis(6L);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myQueue;

    public TypeScriptConfigLibraryUpdater(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "<init>"));
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("Update typescript config additional roots/paths", UPDATE_TIME, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myQueue.setRestartTimerOnAdd(true);
    }

    public void queueToUpdate() {
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null || !settings.isAutoIncludeConfigPaths() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myQueue.queue(new Update(this){

            public void run() {
                TypeScriptConfigLibraryUpdater.this.update();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
            if (files.isEmpty()) {
                return;
            }
            for (TypeScriptConfig file : files) {
                if (!file.hasErrors()) continue;
                return;
            }
            this.processConfigs(files);
        }
        finally {
            token.finish();
        }
    }

    private void processConfigs(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "processConfigs"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> libraryFiles = this.getFilesToUpdate(configs);
        this.updateFiles(configs, libraryFiles);
    }

    private void updateFiles(@NotNull Collection<TypeScriptConfig> configs, @NotNull Collection<VirtualFile> possibleLibraryFiles) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "updateFiles"));
        }
        if (possibleLibraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleLibraryFiles", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "updateFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        List fileOutOfProjectScope = ContainerUtil.filter(possibleLibraryFiles, file -> !scope.accept(file));
        if (!TypeScriptLibraryUtil.checkNeedUpdate(this.myProject, LIBRARY_NAME, fileOutOfProjectScope)) {
            return;
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
        assert (service != null);
        ModificationTracker tracker = service.getTracker();
        long count = tracker.getModificationCount();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "lambda$updateFiles$2"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (configs == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "lambda$null$1"));
                }
                TypeScriptLibraryUtil.updateLibrary(this.myProject, this.getModules(configs), LIBRARY_NAME, fileOutOfProjectScope, true);
            });
        }, o -> count != tracker.getModificationCount());
    }

    private Collection<Module> getModules(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getModules"));
        }
        return TypeScriptLibraryUtil.getModules(this.myProject, ContainerUtil.map(configs, TypeScriptConfig::getConfigFile));
    }

    @NotNull
    private Collection<VirtualFile> getFilesToUpdate(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getFilesToUpdate"));
        }
        if (configs.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getFilesToUpdate"));
            }
            return list;
        }
        HashSet toUpdate = ContainerUtil.newHashSet();
        for (TypeScriptConfig config2 : configs) {
            Collection<PsiFileSystemItem> dirs = config2.getRootDirs();
            for (PsiFileSystemItem dir : dirs) {
                String path;
                VirtualFile file = dir.getVirtualFile();
                if (file == null || (path = file.getCanonicalPath()) == null || path.length() <= 2) continue;
                toUpdate.add(file);
            }
            toUpdate.addAll(this.getBaseUrlRelatedFiles(config2));
        }
        HashSet hashSet = toUpdate;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getFilesToUpdate"));
        }
        return hashSet;
    }

    @NotNull
    protected Collection<VirtualFile> getBaseUrlRelatedFiles(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlRelatedFiles"));
        }
        VirtualFile baseUrl = config2.getBaseUrl();
        if (baseUrl == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlRelatedFiles"));
            }
            return list;
        }
        Collection<JSModulePathSubstitution> paths = config2.getPaths();
        if (paths.isEmpty()) {
            List<VirtualFile> list = TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlRelatedFiles"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSModulePathSubstitution substitution : paths) {
            for (String path : substitution.getMappings()) {
                String canonicalPath;
                if (!TypeScriptConfigLibraryUpdater.pathCanBeProcessed(path)) {
                    List<VirtualFile> list = TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlRelatedFiles"));
                    }
                    return list;
                }
                boolean endsWithStar = path.contains("*");
                String normalizedPath = endsWithStar ? path.substring(0, path.indexOf("*")) : path;
                VirtualFile pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, normalizedPath);
                if (!endsWithStar && pathUrl == null) {
                    for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
                        pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, normalizedPath + extension);
                        if (pathUrl != null) break;
                    }
                }
                if (pathUrl == null || (canonicalPath = pathUrl.getCanonicalPath()) == null || canonicalPath.length() <= 2) continue;
                result.add(pathUrl);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlRelatedFiles"));
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getBaseUrlFile(@NotNull VirtualFile baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlFile"));
        }
        String path = baseUrl.getCanonicalPath();
        List list = path == null || path.length() <= 2 ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)baseUrl);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater", "getBaseUrlFile"));
        }
        return list;
    }

    private static boolean pathCanBeProcessed(String pattern) {
        return JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || pattern.contains("/*") || !pattern.contains("*");
    }
}

