/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionJSFix
implements LocalQuickFix {
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/inspectjs/InspectionJSFix", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/sixrr/inspectjs/InspectionJSFix", "applyFix"));
        }
        PsiElement problemElement = descriptor2.getPsiElement();
        if (problemElement == null || !problemElement.isValid()) {
            return;
        }
        if (InspectionJSFix.isQuickFixOnReadOnlyFile(problemElement)) {
            return;
        }
        try {
            this.doFix(project, descriptor2);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance((String)className);
            logger.error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2) throws IncorrectOperationException;

    protected static void deleteElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/sixrr/inspectjs/InspectionJSFix", "deleteElement"));
        }
        ASTNode node = element.getNode();
        ASTNode parent = element.getParent().getNode();
        parent.removeChild(node);
    }

    protected static void replaceExpression(JSExpression expression, String newExpression) throws IncorrectOperationException {
        JSExpressionStatement expressionStatement;
        JSLanguageDialect javascript = JSUtils.getDialect(expression.getContainingFile());
        ASTNode fromText = JSChangeUtil.createStatementFromText(expression.getProject(), newExpression + ';', javascript);
        PsiElement element = fromText != null ? fromText.getPsi() : null;
        JSExpressionStatement jSExpressionStatement = expressionStatement = element instanceof JSExpressionStatement ? (JSExpressionStatement)element : null;
        if (expressionStatement == null) {
            return;
        }
        JSExpression newExp = expressionStatement.getExpression();
        ASTNode newExpressionNode = newExp.getNode();
        ASTNode expressionNode = expression.getNode();
        PsiElement parent = expression.getParent();
        ASTNode parentNode = parent.getNode();
        parentNode.replaceChild(expressionNode, newExpressionNode);
    }

    protected static void replaceStatement(JSStatement statement, @NonNls String newStatement) throws IncorrectOperationException {
        JSStatement newStmt;
        JSLanguageDialect javascript = JSUtils.getDialect(statement.getContainingFile());
        ASTNode fromText = JSChangeUtil.createJSTreeFromText(statement.getProject(), newStatement, javascript);
        PsiElement element = fromText != null ? fromText.getPsi() : null;
        JSStatement jSStatement = newStmt = element instanceof JSStatement ? (JSStatement)element : null;
        if (newStmt == null) {
            return;
        }
        ASTNode parentNode = statement.getParent().getNode();
        ASTNode node = statement.getNode();
        parentNode.addChildren(fromText, null, node);
        parentNode.removeChild(node);
    }

    private static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
        PsiFile containingPsiFile = problemElement.getContainingFile();
        if (containingPsiFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingPsiFile.getVirtualFile();
        Project project = problemElement.getProject();
        return !FileModificationService.getInstance().prepareVirtualFilesForWrite(project, Collections.singletonList(virtualFile));
    }
}

