/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.oss.geronimo.server.GeronimoHttpPortConfig;
import com.intellij.javaee.oss.geronimo.server.GeronimoLocalModel;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class GeronimoPortConfig
extends JavaeePortConfig {
    private static final Logger LOG = Logger.getInstance(GeronimoHttpPortConfig.class);
    private final File myConfigXml;
    private final File myConfigSubstProps;
    private final String myConfig;
    private final String myGBean;

    protected GeronimoPortConfig(String home, String config, String gbean) {
        this.myConfigXml = new File(home, FileUtil.toSystemDependentName((String)"var/config/config.xml"));
        this.myConfigSubstProps = new File(home, FileUtil.toSystemDependentName((String)"var/config/config-substitutions.properties"));
        this.myConfig = config;
        this.myGBean = gbean;
    }

    protected long getStamp(JavaeeServerModel data) {
        return GeronimoPortConfig.getStamp((File)this.myConfigXml) ^ GeronimoPortConfig.getStamp((File)this.myConfigSubstProps);
    }

    protected int getPort(JavaeeServerModel model) {
        if (this.myConfigXml.exists()) {
            try {
                Element attribute;
                Element bean;
                Element root = JDOMUtil.load((File)this.myConfigXml);
                Element cfg = GeronimoPortConfig.getChildByPattern((Element)root, (String)"configuration", (String)"name", (String)("geronimo/" + this.myConfig + "/.*"));
                if (cfg == null) {
                    cfg = GeronimoPortConfig.getChildByPattern((Element)root, (String)"module", (String)"name", (String)("(:?geronimo|org\\.apache\\.geronimo\\.(:?configs|framework))/" + this.myConfig + "/.*"));
                }
                if (cfg != null && (bean = GeronimoPortConfig.getChildByPattern((Element)cfg, (String)"gbean", (String)"name", (String)this.myGBean)) != null && (attribute = GeronimoPortConfig.getChild((Element)bean, (String)"attribute", (String)"name", (String)"port")) != null) {
                    return this.parse(attribute.getTextTrim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    protected int parse(String port) throws NumberFormatException {
        Matcher matcher = Pattern.compile("\\$\\{\\s*(\\w+)\\s*\\+\\s*(\\w+)\\s*\\}").matcher(port);
        if (matcher.matches()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(this.myConfigSubstProps));
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
                return Integer.MAX_VALUE;
            }
            String part1 = properties.getProperty(matcher.group(1), "0");
            String part2 = properties.getProperty(matcher.group(2), "0");
            return Integer.parseInt(part1) + Integer.parseInt(part2);
        }
        return Integer.parseInt(port);
    }

    protected static abstract class GeronimoFactoryBase
    implements JavaeePortConfig.Factory<GeronimoLocalModel> {
        @NonNls
        private final String myKey;

        protected GeronimoFactoryBase(@NonNls String key) {
            this.myKey = key;
        }

        @NotNull
        public CachedConfig.Key createKey(GeronimoLocalModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome(), this.myKey});
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/server/GeronimoPortConfig$GeronimoFactoryBase", "createKey"));
            }
            return key;
        }

        @NotNull
        public abstract JavaeePortConfig createConfig(GeronimoLocalModel var1);
    }
}

