/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.SourcePosition;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandler;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.xdebugger.XSourcePosition;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornSourceMapHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceMapList", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;)V", "fileFinder", "Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "getFileFinder", "()Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "fileFinder$delegate", "Lkotlin/Lazy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSourceMapList", "()Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "getGeneratedPosition", "Lcom/intellij/debugger/SourcePosition;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "generatedLocation", "Lcom/sun/jdi/Location;", "nashorn-debugger"})
public final class NashornSourceMapHandler {
    @NotNull
    private final Lazy fileFinder$delegate;
    @NotNull
    private final Project project;
    @Nullable
    private final PreloadedSourceMapList sourceMapList;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    public final LocalFileSystemFileFinder getFileFinder() {
        Lazy lazy = this.fileFinder$delegate;
        NashornSourceMapHandler nashornSourceMapHandler = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (LocalFileSystemFileFinder)lazy.getValue();
    }

    @Nullable
    public final SourcePosition getGeneratedPosition(@Nullable XSourcePosition sourcePosition) {
        if (sourcePosition != null && this.sourceMapList != null) {
            List list = CollectionsKt.listOf((Object)new UrlImpl(sourcePosition.getFile().getPath()));
            VirtualFile virtualFile = sourcePosition.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
            List rawLocations = SourceMapHelperKt.getRawLocations$default((Project)this.project, (PreloadedSourceMapList)this.sourceMapList, (List)list, (VirtualFile)virtualFile, (int)sourcePosition.getLine(), null, null, (int)0, (int)224, null);
            if (!rawLocations.isEmpty()) {
                PsiFile file;
                Location location = (Location)rawLocations.get(0);
                LocalFileSystemFileFinder localFileSystemFileFinder = this.getFileFinder();
                Url url = location.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
                VirtualFile virtualFile2 = localFileSystemFileFinder.findFile(url, this.project);
                PsiFile psiFile = file = virtualFile2 != null ? PsiManager.getInstance((Project)this.project).findFile(virtualFile2) : null;
                if (file != null) {
                    return SourcePosition.createFromLine((PsiFile)file, (int)location.getLine());
                }
            }
        }
        return null;
    }

    @Nullable
    public final SourceInfo getSourceInfo(@Nullable VirtualFile generatedFile, @NotNull com.sun.jdi.Location generatedLocation) {
        Intrinsics.checkParameterIsNotNull((Object)generatedLocation, (String)"generatedLocation");
        if (generatedFile == null) {
            return null;
        }
        PreloadedSourceMapList preloadedSourceMapList = this.sourceMapList;
        if (preloadedSourceMapList == null || (preloadedSourceMapList = preloadedSourceMapList.getByScript((Url)new LocalFileUrl(generatedFile.getPath()))) == null) {
            return null;
        }
        PreloadedSourceMapList sourceMap = preloadedSourceMapList;
        MappingEntry mappingEntry = SourceMapHelperKt.findMapping((SourceMap)sourceMap, (int)(generatedLocation.lineNumber() - 1), (int)0);
        if (mappingEntry == null) {
            return null;
        }
        MappingEntry mapping = mappingEntry;
        Url url = sourceMap.getSourceResolver().getSource(mapping);
        if (url == null) {
            return null;
        }
        Url sourceUrl = url;
        VirtualFile virtualFile = this.getFileFinder().findFile(sourceUrl, this.project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceFile = virtualFile;
        return new SourceInfo(sourceFile, mapping.getSourceLine(), mapping.getSourceColumn(), 0, null, sourceUrl, 24, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final PreloadedSourceMapList getSourceMapList() {
        return this.sourceMapList;
    }

    public NashornSourceMapHandler(@NotNull Project project, @Nullable PreloadedSourceMapList sourceMapList) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.sourceMapList = sourceMapList;
        this.fileFinder$delegate = LazyKt.lazy((Function0)fileFinder.2.INSTANCE);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NashornSourceMapHandler.class), "fileFinder", "getFileFinder()Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;"))};
    }
}

