/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.debugger.jdi.ClassValue;
import com.jetbrains.debugger.jdi.JdiArray;
import com.jetbrains.debugger.jdi.JdiObject;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import gnu.trove.TLongObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public final class JdiValueManager
extends ValueManager {
    private static final ObjectValueFactory OBJECT_VALUE_FACTORY = new ObjectValueFactory(){

        @Override
        public ObjectValue create(@NotNull ObjectReference objectReference, @NotNull JdiValueManager valueManager) {
            if (objectReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/jetbrains/debugger/jdi/JdiValueManager$1", "create"));
            }
            if (valueManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/debugger/jdi/JdiValueManager$1", "create"));
            }
            return new JdiObject(ValueType.OBJECT, objectReference, valueManager);
        }
    };
    private final DebuggerManagerThreadImpl managerThread;
    private final DebugProcessImpl debugProcess;
    private final TLongObjectHashMap<Value> refToValue;

    public JdiValueManager(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/debugger/jdi/JdiValueManager", "<init>"));
        }
        this.refToValue = new TLongObjectHashMap();
        this.debugProcess = debugProcess;
        this.managerThread = debugProcess.getManagerThread();
    }

    public DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public UserDataHolderEx getProcessLevelCache() {
        return this.debugProcess;
    }

    @NotNull
    public DebuggerManagerThreadImpl getManagerThread() {
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = this.managerThread;
        if (debuggerManagerThreadImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "getManagerThread"));
        }
        return debuggerManagerThreadImpl;
    }

    @NotNull
    public Value createValue(@Nullable com.sun.jdi.Value value) {
        Value value2 = this.createValue(value, OBJECT_VALUE_FACTORY);
        if (value2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
        }
        return value2;
    }

    @NotNull
    public Value createValue(@Nullable com.sun.jdi.Value value, @NotNull ObjectValueFactory objectValueFactory) {
        if (objectValueFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectValueFactory", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
        }
        if (value == null) {
            org.jetbrains.debugger.values.PrimitiveValue primitiveValue = org.jetbrains.debugger.values.PrimitiveValue.NULL;
            if (primitiveValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
            }
            return primitiveValue;
        }
        if (value instanceof PrimitiveValue) {
            if (value instanceof ByteValue || value instanceof ShortValue || value instanceof IntegerValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, ((PrimitiveValue)value).intValue());
                if (primitiveValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
                }
                return primitiveValue;
            }
            if (value instanceof LongValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, ((PrimitiveValue)value).longValue());
                if (primitiveValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
                }
                return primitiveValue;
            }
            if (value instanceof FloatValue || value instanceof DoubleValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.NUMBER, Double.toString(((PrimitiveValue)value).doubleValue()));
                if (primitiveValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
                }
                return primitiveValue;
            }
            if (value instanceof BooleanValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.BOOLEAN, Boolean.toString(((PrimitiveValue)value).booleanValue()));
                if (primitiveValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
                }
                return primitiveValue;
            }
            if (value instanceof CharValue) {
                org.jetbrains.debugger.values.PrimitiveValue primitiveValue = new org.jetbrains.debugger.values.PrimitiveValue(ValueType.STRING, Character.toString(((PrimitiveValue)value).charValue()));
                if (primitiveValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
                }
                return primitiveValue;
            }
        } else if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            Object result = this.getCachedValue(objectReference);
            if (result != null) {
                Value value2 = result;
                if (value2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
                }
                return value2;
            }
            result = value instanceof StringReference ? new org.jetbrains.debugger.values.PrimitiveValue(ValueType.STRING, ((StringReference)value).value()) : (value instanceof ArrayReference ? new JdiArray((ArrayReference)value, this) : (value instanceof ClassObjectReference ? new ClassValue((ClassObjectReference)value, this) : objectValueFactory.create(objectReference, this)));
            Value value3 = this.getOrCacheValue(objectReference, (Value)result);
            if (value3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "createValue"));
            }
            return value3;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Value getCachedValue(@NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/jetbrains/debugger/jdi/JdiValueManager", "getCachedValue"));
        }
        TLongObjectHashMap<Value> tLongObjectHashMap = this.refToValue;
        synchronized (tLongObjectHashMap) {
            return (Value)this.refToValue.get(objectReference.uniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Value getOrCacheValue(@NotNull ObjectReference objectReference, @NotNull Value value) {
        if (objectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/jetbrains/debugger/jdi/JdiValueManager", "getOrCacheValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/debugger/jdi/JdiValueManager", "getOrCacheValue"));
        }
        long uniqueId = objectReference.uniqueID();
        TLongObjectHashMap<Value> tLongObjectHashMap = this.refToValue;
        // MONITORENTER : tLongObjectHashMap
        Value newValue = (Value)this.refToValue.get(uniqueId);
        if (newValue == null) {
            this.refToValue.put(uniqueId, (Object)value);
            Value value2 = value;
            // MONITOREXIT : tLongObjectHashMap
            if (value2 != null) return value2;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "getOrCacheValue"));
        }
        Value value3 = newValue;
        // MONITOREXIT : tLongObjectHashMap
        if (value3 != null) return value3;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiValueManager", "getOrCacheValue"));
    }

    public static abstract class ObjectValueFactory {
        public abstract ObjectValue create(@NotNull ObjectReference var1, @NotNull JdiValueManager var2);
    }
}

