/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlCompletionContributor;
import com.intellij.freemarker.FtlIndexInfo;
import com.intellij.freemarker.FtlPathGenerator;
import com.intellij.freemarker.inspections.CreateFromUsageIntentionBase;
import com.intellij.freemarker.inspections.FtlDeclarationType;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlImportCallInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlImportCallInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!isOnTheFly) {
                    return;
                }
                if (element instanceof FtlReferenceExpression) {
                    FtlImportCallInspection.this.checkCall(((FtlReferenceExpression)element).getReference(), holder);
                } else if (element instanceof FtlIndexExpression) {
                    FtlImportCallInspection.this.checkCall(((FtlIndexExpression)element).getQualifiedReference(), holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private void checkCall(@Nullable FtlQualifiedReference reference, ProblemsHolder holder) {
        String namespace;
        boolean macro;
        if (reference == null || reference.getAssignDeclaration() != null || reference.resolve() != null) {
            return;
        }
        if (reference.getValidExpression().getParent() instanceof FtlMacro) {
            macro = true;
        } else if (reference.isCall()) {
            macro = false;
        } else {
            return;
        }
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        if (qualifier == null) {
            namespace = null;
        } else {
            if (qualifier.getType() != null) {
                return;
            }
            namespace = qualifier.getText();
        }
        String name = reference.getReferenceName();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)reference.getElement());
        if (module == null) {
            return;
        }
        SmartList fixes = new SmartList();
        FtlCompletionContributor.processAllFtlFiles(module, (FileBasedIndex.ValueProcessor<FtlIndexInfo>)((FileBasedIndex.ValueProcessor)(arg_0, arg_1) -> this.lambda$checkCall$0(macro, name, (List)fixes, namespace, module, arg_0, arg_1)));
        if (fixes.isEmpty()) {
            return;
        }
        holder.registerProblem(InspectionManager.getInstance((Project)reference.getElement().getProject()).createProblemDescriptor((PsiElement)reference.getElement(), reference.getRangeInElement(), "", ProblemHighlightType.WEAK_WARNING, holder.isOnTheFly(), fixes.toArray(new LocalQuickFix[fixes.size()])));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.import.calls.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlImportCallInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection", "getShortName"));
        }
        return "FtlImportCallInspection";
    }

    @Nullable
    protected FtlDeclarationType getDeclarationType(Project project) {
        String explicit = FreeMarkerBundle.message("explicit", new Object[0]);
        int i = Messages.showYesNoCancelDialog((Project)project, (String)FreeMarkerBundle.message("choose.declaration.type.implicit.or.explicit", new Object[0]), (String)FreeMarkerBundle.message("choose.declaration.type", new Object[0]), (String)explicit, (String)FreeMarkerBundle.message("implicit", new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
        if (i == 0) {
            return FtlDeclarationType.EXPLICIT;
        }
        if (i == 1) {
            return FtlDeclarationType.IMPLICIT;
        }
        return null;
    }

    private /* synthetic */ boolean lambda$checkCall$0(boolean macro, String name, List fixes, String namespace, Module module, VirtualFile file, FtlIndexInfo value) {
        Set<String> list;
        Set<String> set = list = macro ? value.macros : value.functions;
        if (list.contains(name)) {
            fixes.add(new FtlImportCallQuickFix(namespace, file, module));
        }
        return true;
    }

    private class FtlImportCallQuickFix
    extends CreateFromUsageIntentionBase
    implements LocalQuickFix,
    IntentionAction {
        private final String myNamespace;
        private final VirtualFile myFile;
        private final Module myModule;

        public FtlImportCallQuickFix(String namespace, VirtualFile file, Module module) {
            this.myNamespace = namespace;
            this.myFile = file;
            this.myModule = module;
        }

        @NotNull
        public String getName() {
            String string = this.myNamespace == null ? FreeMarkerBundle.message("fix.include.file", this.myFile.getName()) : FreeMarkerBundle.message("fix.import.file", this.myFile.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "getText"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "isAvailable"));
            }
            return true;
        }

        @NotNull
        public String getFamilyName() {
            String string = FreeMarkerBundle.message("fix.import.or.include.file", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "applyFix"));
            }
            throw new UnsupportedOperationException("Method applyFix is not yet implemented in " + this.getClass().getName());
        }

        @Override
        protected void addDeclaration(PsiFile sourceFile, Editor sourceEditor, PsiFile targetFile, Editor editor) throws IncorrectOperationException {
            String relativePath = new FtlPathGenerator(targetFile, this.myModule).generatePath(this.myFile);
            if (relativePath == null) {
                relativePath = this.myFile.getName();
            }
            FtlImportCallQuickFix.prepareInsertionPlace(sourceFile, targetFile, editor);
            FtlDirectiveStyle style = FtlLexer.guessDirectiveStyle(editor.getDocument().getCharsSequence());
            StringBuilder sb = new StringBuilder();
            String directiveName = "#" + (this.myNamespace == null ? "include" : "import");
            sb.append(style.getDirectiveStartChar()).append(directiveName).append(" '").append(relativePath).append("'");
            if (this.myNamespace != null) {
                sb.append(" as ").append(this.myNamespace);
            }
            sb.append(String.valueOf(style.getDirectiveEndChar()));
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)sb.toString());
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix", "invoke"));
            }
            FtlDeclarationType type = FtlImportCallInspection.this.getDeclarationType(project);
            if (type == null) {
                return;
            }
            if (type == FtlDeclarationType.EXPLICIT) {
                this.addDeclaration(file, editor, file);
                return;
            }
            this.chooseTargetFile(file, editor);
        }
    }
}

