/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.files.FtlFileElementTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage;
    private Language myBaseLanguage;
    private Set<Language> myAllLanguages;

    public FtlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        this(manager, virtualFile, physical, FtlFileViewProvider.getSubstitutedLanguage(manager, virtualFile), FtlLexer.guessDirectiveStyle(virtualFile, manager.getProject()).getLanguage());
    }

    private FtlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, Language templateDataLanguage, Language baseLanguage) {
        super(manager, virtualFile, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
        this.setBaseLanguage(baseLanguage);
    }

    private static Language getSubstitutedLanguage(PsiManager manager, VirtualFile virtualFile) {
        Language language = FtlFileViewProvider.getTemplateDataLanguage(virtualFile, manager.getProject());
        return language instanceof TemplateLanguage ? PlainTextLanguage.INSTANCE : LanguageSubstitutors.INSTANCE.substituteLanguage(language, virtualFile, manager.getProject());
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFileViewProvider", "getBaseLanguage"));
        }
        return language;
    }

    public void contentsSynchronized() {
        super.contentsSynchronized();
        Language language = FtlLexer.guessDirectiveStyle(this.getContents()).getLanguage();
        if (this.myBaseLanguage != language) {
            this.removeFile(this.myBaseLanguage);
            this.setBaseLanguage(language);
        }
    }

    private void setBaseLanguage(Language language) {
        this.myBaseLanguage = language;
        this.myAllLanguages = Collections.unmodifiableSet(ContainerUtil.newTroveSet((Object[])new Language[]{this.myBaseLanguage, this.myTemplateDataLanguage}));
    }

    @NotNull
    public Set<Language> getLanguages() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<Language> set = this.myAllLanguages;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/freemarker/psi/files/FtlFileViewProvider", "createFile"));
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)FtlFileElementTypes.TEMPLATE_DATA);
            return file;
        }
        return null;
    }

    protected FtlFileViewProvider cloneInner(VirtualFile copy) {
        return new FtlFileViewProvider(this.getManager(), copy, false, this.myTemplateDataLanguage, this.myBaseLanguage);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    public static Language getTemplateDataLanguage(VirtualFile virtualFile, Project project) {
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile);
        if (language == null) {
            return "ftlx".equals(virtualFile.getExtension()) ? XMLLanguage.INSTANCE : HTMLLanguage.INSTANCE;
        }
        return language;
    }
}

