/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.view.tool.ArtifactSyncTrackerListener;
import com.intellij.openapi.compiler.CompilationStatusAdapter;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactSyncTracker
implements BaseComponent {
    private final Project myProject;
    private ArtifactSyncTrackerListener myListener;
    private Map<CommonModel, ServerSync> myServerToSync;

    public ArtifactSyncTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "<init>"));
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusAdapter(){

            public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    ArtifactSyncTracker.this.onCompilationSuccess(compileContext);
                }
            }
        });
    }

    public Map<CommonModel, ServerSync> getServerToSync(boolean forceUpdate) {
        Map<CommonModel, ServerSync> oldServerToSync = this.myServerToSync;
        if (oldServerToSync != null && !forceUpdate) {
            return oldServerToSync;
        }
        THashMap result = new THashMap();
        new ServersIterator((Map)result, oldServerToSync){
            final /* synthetic */ Map val$result;
            final /* synthetic */ Map val$oldServerToSync;
            {
                this.val$result = map;
                this.val$oldServerToSync = map2;
            }

            @Override
            protected void processServer(CommonModel server) {
                this.val$result.put(server, this.val$oldServerToSync != null && this.val$oldServerToSync.containsKey(server) ? (ServerSync)this.val$oldServerToSync.get(server) : new ServerSync());
            }
        }.iterateServers();
        this.myServerToSync = result;
        return result;
    }

    public void setListener(ArtifactSyncTrackerListener listener) {
        this.myListener = listener;
    }

    private void onCompilationSuccess(CompileContext compileContext) {
        Artifact[] compiledArtifacts = ArtifactCompileScope.getArtifacts((CompileScope)compileContext.getCompileScope());
        if (compiledArtifacts == null) {
            return;
        }
        final List<Artifact> compiledArtifactsList = Arrays.asList(compiledArtifacts);
        new ServersIterator(){

            @Override
            protected void processServer(CommonModel server) {
                ArtifactSyncTracker.this.findOrCreateServerSync(server).markArtifactsUnsynced(compiledArtifactsList);
            }
        }.iterateServers();
        if (this.myListener != null) {
            this.myListener.artifactsUnsynced();
        }
    }

    public void updateServersList() {
        this.getServerToSync(true);
    }

    public boolean isArtifactSynced(CommonStrategy server, Artifact artifact) {
        return this.findOrCreateServerSync((CommonModel)server).isArtifactSynced(artifact);
    }

    public void updateDeploymentSync(CommonStrategy server, DeploymentModel model, DeploymentStatus newStatus) {
        Artifact artifact = model.getArtifact();
        if (artifact != null) {
            this.updateArtifactSync(server, artifact, newStatus);
        }
    }

    private void updateArtifactSync(CommonStrategy server, Artifact artifact, DeploymentStatus newStatus) {
        if (newStatus == DeploymentStatus.DEPLOYED) {
            this.findOrCreateServerSync((CommonModel)server).markArtifactSynced(artifact);
        }
    }

    @NotNull
    private ServerSync findOrCreateServerSync(@NotNull CommonModel server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
        }
        Map<CommonModel, ServerSync> serverToSync = this.getServerToSync(false);
        if (serverToSync.containsKey(server)) {
            ServerSync serverSync = serverToSync.get(server);
            if (serverSync == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
            }
            return serverSync;
        }
        serverToSync = this.getServerToSync(true);
        if (serverToSync.containsKey(server)) {
            ServerSync serverSync = serverToSync.get(server);
            if (serverSync == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
            }
            return serverSync;
        }
        ServerSync result = new ServerSync();
        serverToSync.put(server, result);
        ServerSync serverSync = result;
        if (serverSync == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
        }
        return serverSync;
    }

    private abstract class ServersIterator {
        private ServersIterator() {
        }

        public void iterateServers() {
            for (RunnerAndConfigurationSettings configuration : RunManager.getInstance((Project)ArtifactSyncTracker.this.myProject).getAllSettings()) {
                if (!(configuration.getConfiguration() instanceof CommonModel)) continue;
                this.processServer((CommonModel)configuration.getConfiguration());
            }
        }

        protected abstract void processServer(CommonModel var1);
    }

    private static class ServerSync {
        private final Set<Artifact> mySyncedArtifacts = new HashSet<Artifact>();

        public void markArtifactsUnsynced(Collection<Artifact> unsyncedArtifacts) {
            this.mySyncedArtifacts.removeAll(unsyncedArtifacts);
        }

        public void markArtifactSynced(Artifact syncedArtifact) {
            this.mySyncedArtifacts.add(syncedArtifact);
        }

        public boolean isArtifactSynced(Artifact artifact) {
            return this.mySyncedArtifacts.contains(artifact);
        }
    }
}

