/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grape;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.grape.GrapeRunner;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GrabDependencies
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.grape.GrabDependencies");
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Grape", NotificationDisplayType.BALLOON, true);
    public static final String GRAPE_RUNNER = "org.jetbrains.plugins.groovy.grape.GrapeRunner";

    @NotNull
    public String getText() {
        if ("Grab the artifacts" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grape/GrabDependencies", "getText"));
        }
        return "Grab the artifacts";
    }

    @NotNull
    public String getFamilyName() {
        if ("Grab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grape/GrabDependencies", "getFamilyName"));
        }
        return "Grab";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grape/GrabDependencies", "isAvailable"));
        }
        if (!GrabDependencies.isCorrectModule(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        GrAnnotation anno = (GrAnnotation)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, GrAnnotation.class, (boolean)false);
        if (anno != null && GrabDependencies.isGrabAnnotation(anno)) {
            return true;
        }
        PsiElement at = file.findElementAt(offset);
        return at != null && GrabDependencies.isUnresolvedRefName(at) && GrabDependencies.findGrab(file) != null;
    }

    private static PsiAnnotation findGrab(PsiFile file) {
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        return (PsiAnnotation)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            PsiClass grab = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("groovy.lang.Grab", file.getResolveScope());
            Ref result = Ref.create();
            if (grab != null) {
                ReferencesSearch.search((PsiElement)grab, (SearchScope)new LocalSearchScope((PsiElement)file)).forEach(reference -> {
                    PsiElement parent;
                    if (reference instanceof GrCodeReferenceElement && (parent = ((GrCodeReferenceElement)reference).getParent()) instanceof PsiAnnotation) {
                        result.set((Object)((PsiAnnotation)parent));
                        return false;
                    }
                    return true;
                });
            }
            return CachedValueProvider.Result.create((Object)result.get(), (Object[])new Object[]{file});
        });
    }

    private static boolean isUnresolvedRefName(@NotNull PsiElement at) {
        if (at == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "org/jetbrains/plugins/groovy/grape/GrabDependencies", "isUnresolvedRefName"));
        }
        PsiElement parent = at.getParent();
        return parent instanceof GrReferenceElement && ((GrReferenceElement)parent).getReferenceNameElement() == at && ((GrReferenceElement)parent).resolve() == null;
    }

    private static boolean isGrabAnnotation(@NotNull GrAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "org/jetbrains/plugins/groovy/grape/GrabDependencies", "isGrabAnnotation"));
        }
        String qname = anno.getQualifiedName();
        return qname != null && (qname.startsWith("groovy.lang.Grab") || "groovy.lang.Grapes".equals(qname));
    }

    private static boolean isCorrectModule(PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            return false;
        }
        return file.getOriginalFile().getVirtualFile() != null && sdk.getSdkType() instanceof JavaSdkType;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grape/GrabDependencies", "invoke"));
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        VirtualFile vfile = file.getOriginalFile().getVirtualFile();
        assert (vfile != null);
        if (JavaPsiFacade.getInstance((Project)project).findClass("org.apache.ivy.core.report.ResolveReport", file.getResolveScope()) == null) {
            Messages.showErrorDialog((String)"Sorry, but IDEA cannot @Grab the dependencies without Ivy. Please add Ivy to your module dependencies and re-run the action.", (String)"Ivy Missing");
            return;
        }
        Map<String, String> queries = GrabDependencies.prepareQueries(file);
        final HashMap<String, GeneralCommandLine> lines = new HashMap<String, GeneralCommandLine>();
        for (String grabText : queries.keySet()) {
            JavaParameters javaParameters = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
            try {
                DefaultGroovyScriptRunner.configureGenericGroovyRunner(javaParameters, module, GRAPE_RUNNER, false, true, true, false);
                javaParameters.getClassPath().add(PathUtil.getJarPathForClass(GrapeRunner.class));
                javaParameters.getProgramParametersList().add(queries.get(grabText));
                javaParameters.setUseDynamicClasspath(true);
                lines.put(grabText, javaParameters.toCommandLine());
            }
            catch (CantRunException e) {
                String title = "Can't run @Grab: " + ExceptionUtil.getMessage((Throwable)e);
                NOTIFICATION_GROUP.createNotification(title, ExceptionUtil.getThrowableText((Throwable)e), NotificationType.ERROR, null).notify(project);
                return;
            }
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Processing @Grab Annotations"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/groovy/grape/GrabDependencies$1", "run"));
                }
                int jarCount = 0;
                String messages = "";
                for (Map.Entry entry : lines.entrySet()) {
                    String grabText = (String)entry.getKey();
                    indicator.setText2(grabText);
                    try {
                        GrapeProcessHandler handler = new GrapeProcessHandler((GeneralCommandLine)entry.getValue(), module);
                        handler.startNotify();
                        handler.waitFor();
                        jarCount += handler.jarCount;
                        messages = messages + "<b>" + grabText + "</b>: " + handler.messages + "<p>";
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }
                String finalMessages = messages;
                String title = jarCount + " Grape dependency jar" + (jarCount == 1 ? "" : "s") + " added";
                NOTIFICATION_GROUP.createNotification(title, finalMessages, NotificationType.INFORMATION, null).notify(project);
            }
        });
    }

    static Map<String, String> prepareQueries(PsiFile file) {
        final LinkedHashSet grabs = new LinkedHashSet();
        THashSet excludes = new THashSet();
        THashSet resolvers = new THashSet();
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Set)excludes, (Set)resolvers){
            final /* synthetic */ Set val$excludes;
            final /* synthetic */ Set val$resolvers;
            {
                this.val$excludes = set2;
                this.val$resolvers = set3;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof GrAnnotation) {
                    GrAnnotation anno = (GrAnnotation)element;
                    String qname = anno.getQualifiedName();
                    if ("groovy.lang.Grab".equals(qname)) {
                        grabs.add(anno);
                    } else if ("groovy.lang.GrabExclude".equals(qname)) {
                        this.val$excludes.add(anno);
                    } else if ("groovy.lang.GrabResolver".equals(qname)) {
                        this.val$resolvers.add(anno);
                    }
                }
                super.visitElement(element);
            }
        });
        Function mapper = grAnnotation -> grAnnotation.getText();
        String common = StringUtil.join((Collection)excludes, (Function)mapper, (String)" ") + " " + StringUtil.join((Collection)resolvers, (Function)mapper, (String)" ");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (GrAnnotation grab : grabs) {
            String grabText = grab.getText();
            result.put(grabText, (grabText + " " + common).trim());
        }
        return result;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class GrapeProcessHandler
    extends OSProcessHandler {
        private final StringBuilder myStdOut = new StringBuilder();
        private final StringBuilder myStdErr = new StringBuilder();
        private final Module myModule;
        int jarCount;
        String messages = "";

        public GrapeProcessHandler(GeneralCommandLine commandLine, Module module) throws ExecutionException {
            super(commandLine);
            this.myModule = module;
        }

        public void notifyTextAvailable(String text, Key outputType) {
            text = StringUtil.convertLineSeparators((String)text);
            if (LOG.isDebugEnabled()) {
                LOG.debug(outputType + text);
            }
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myStdOut.append(text);
            } else if (outputType == ProcessOutputTypes.STDERR) {
                this.myStdErr.append(text);
            }
        }

        private void addGrapeDependencies(List<VirtualFile> jars) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            LibraryTable.ModifiableModel tableModel = model.getModuleLibraryTable().getModifiableModel();
            for (VirtualFile jar : jars) {
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jar);
                if (jarRoot == null) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String libName = "Grab:" + jar.getName();
                for (String classifier : (String[])ContainerUtil.ar((Object[])new String[]{"sources", "source", "src"})) {
                    if (!libName.endsWith("-" + classifier + ".jar")) continue;
                    rootType = OrderRootType.SOURCES;
                    libName = StringUtil.trimEnd((String)libName, (String)("-" + classifier + ".jar")) + ".jar";
                }
                Library library = tableModel.getLibraryByName(libName);
                if (library == null) {
                    library = tableModel.createLibrary(libName);
                }
                Library.ModifiableModel libModel = library.getModifiableModel();
                for (String url : libModel.getUrls(rootType)) {
                    libModel.removeRoot(url, rootType);
                }
                libModel.addRoot(jarRoot, rootType);
                libModel.commit();
            }
            tableModel.commit();
            model.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyProcessTerminated(int exitCode) {
            try {
                final ArrayList jars = new ArrayList();
                for (String line : this.myStdOut.toString().split("\n")) {
                    if (!line.startsWith("URL:")) continue;
                    try {
                        URL url = new URL(line.substring("URL:".length()));
                        File libFile = new File(url.toURI());
                        if (!libFile.exists() || !libFile.getName().endsWith(".jar")) continue;
                        ContainerUtil.addIfNotNull(jars, (Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libFile));
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        LOG.error((Throwable)e);
                    }
                }
                new WriteAction(){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/grape/GrabDependencies$GrapeProcessHandler$1", "run"));
                        }
                        jarCount = jars.size();
                        messages = jarCount + " jar";
                        if (jarCount != 1) {
                            messages = messages + "s";
                        }
                        if (jarCount == 0) {
                            messages = messages + "<br>" + myStdOut.toString().replaceAll("\n", "<br>") + "<p>" + myStdErr.toString().replaceAll("\n", "<br>");
                        }
                        if (!jars.isEmpty()) {
                            this.addGrapeDependencies(jars);
                        }
                    }
                }.execute();
            }
            finally {
                super.notifyProcessTerminated(exitCode);
            }
        }
    }
}

