/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class FlipIfIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention", "processIntention"));
        }
        GrIfStatement ifStatement = (GrIfStatement)DefaultGroovyMethods.asType((Object)element.getParent(), GrIfStatement.class);
        GrIfStatement elseIf = FlipIfIntention.getElseIf(ifStatement);
        GrIfStatement elseIfCopy = (GrIfStatement)DefaultGroovyMethods.asType((Object)elseIf.copy(), GrIfStatement.class);
        elseIf.getCondition().replaceWithExpression(ifStatement.getCondition(), true);
        elseIf.getThenBranch().replaceWithStatement(ifStatement.getThenBranch());
        ifStatement.getCondition().replaceWithExpression(elseIfCopy.getCondition(), true);
        ifStatement.getThenBranch().replaceWithStatement(elseIfCopy.getThenBranch());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention$1", "satisfiedBy"));
                }
                if (!element.getNode().getElementType().equals(GroovyTokenTypes.kIF)) {
                    return false;
                }
                if (!(element.getParent() instanceof GrIfStatement)) {
                    return false;
                }
                GrIfStatement ifStatement = (GrIfStatement)DefaultGroovyMethods.asType((Object)element.getParent(), GrIfStatement.class);
                GrIfStatement elseIf = FlipIfIntention.getElseIf(ifStatement);
                return elseIf != null && FlipIfIntention.checkIf(ifStatement) && FlipIfIntention.checkIf(elseIf);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/FlipIfIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    private static GrIfStatement getElseIf(GrIfStatement ifStatement) {
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null) {
            return null;
        }
        if (elseBranch instanceof GrIfStatement) {
            return (GrIfStatement)DefaultGroovyMethods.asType((Object)elseBranch, GrIfStatement.class);
        }
        return null;
    }

    private static boolean checkIf(GrIfStatement ifStatement) {
        return ifStatement.getCondition() != null && ifStatement.getThenBranch() != null;
    }
}

