/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class AfterCallInstruction
extends InstructionImpl {
    public final CallInstruction myCall;
    private ReturnInstruction myReturnInstruction;

    public AfterCallInstruction(CallInstruction call) {
        super(null);
        this.myCall = call;
    }

    @Override
    public String toString() {
        return super.toString() + "AFTER CALL " + this.myCall.num();
    }

    @Override
    @NotNull
    public Iterable<Instruction> allPredecessors() {
        List<Instruction> list = Collections.singletonList(this.myReturnInstruction);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/AfterCallInstruction", "allPredecessors"));
        }
        return list;
    }

    @Override
    @NotNull
    public Iterable<Instruction> predecessors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/AfterCallInstruction", "predecessors"));
        }
        environment.callStack(this.myReturnInstruction).push(this.myCall);
        List<Instruction> list = Collections.singletonList(this.myReturnInstruction);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/AfterCallInstruction", "predecessors"));
        }
        return list;
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/AfterCallInstruction", "getElementPresentation"));
        }
        return "";
    }

    public void setReturnInstruction(ReturnInstruction returnInstruction) {
        this.myReturnInstruction = returnInstruction;
    }
}

