/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GrStubFileElementType
extends IStubFileElementType<GrFileStub> {
    public static final int STUB_VERSION = 35;

    public GrStubFileElementType(Language language) {
        super(language);
    }

    public StubBuilder getBuilder() {
        return new DefaultStubBuilder(){

            @NotNull
            protected StubElement createStubForFile(@NotNull PsiFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1", "createStubForFile"));
                }
                if (file instanceof GroovyFile) {
                    GrFileStub grFileStub = new GrFileStub((GroovyFile)file);
                    if (grFileStub == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1", "createStubForFile"));
                    }
                    return grFileStub;
                }
                StubElement stubElement = super.createStubForFile(file);
                if (stubElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1", "createStubForFile"));
                }
                return stubElement;
            }

            public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1", "skipChildProcessingWhenBuildingStubs"));
                }
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType$1", "skipChildProcessingWhenBuildingStubs"));
                }
                IElementType childType = node.getElementType();
                IElementType parentType = parent.getElementType();
                if (childType == GroovyElementTypes.PARAMETER && parentType != GroovyElementTypes.PARAMETERS_LIST) {
                    return true;
                }
                if (childType == GroovyElementTypes.PARAMETERS_LIST && !(parent.getPsi() instanceof GrMethod)) {
                    return true;
                }
                if (childType == GroovyElementTypes.MODIFIERS) {
                    if (parentType == GroovyElementTypes.CLASS_INITIALIZER) {
                        return true;
                    }
                    if (parentType == GroovyElementTypes.VARIABLE_DEFINITION && !GroovyElementTypes.VARIABLE_DEFINITION.shouldCreateStub(parent)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public int getStubVersion() {
        return super.getStubVersion() + 35;
    }

    @NotNull
    public String getExternalId() {
        if ("groovy.FILE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "getExternalId"));
        }
        return "groovy.FILE";
    }

    public void serialize(@NotNull GrFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "serialize"));
        }
        dataStream.writeName(stub.getName().toString());
        dataStream.writeBoolean(stub.isScript());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
    }

    @NotNull
    public GrFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        GrFileStub grFileStub = new GrFileStub(name, isScript, GrStubUtils.readStringArray(dataStream));
        if (grFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "deserialize"));
        }
        return grFileStub;
    }

    public void indexStub(@NotNull GrFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrStubFileElementType", "indexStub"));
        }
        String name = stub.getName().toString();
        if (stub.isScript() && name != null) {
            sink.occurrence(GrScriptClassNameIndex.KEY, (Object)name);
            String pName = GrStubUtils.getPackageName(stub);
            String fqn = StringUtil.isEmpty((String)pName) ? name : pName + "." + name;
            sink.occurrence(GrFullScriptNameIndex.KEY, (Object)fqn.hashCode());
        }
        for (String anno : stub.getAnnotations()) {
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)anno);
        }
    }
}

