/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.JspDeploymentManager;
import com.intellij.javaee.oss.server.JavaeeConfigurationType;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatPersistentDataWrapper;
import org.jetbrains.idea.tomcat.TomcatStartupPolicy;
import org.jetbrains.idea.tomcat.server.TomcatIntegration;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatRemoteModel;

public abstract class TomcatConfigurationBase
extends JavaeeConfigurationType {
    public TomcatConfigurationBase(TomcatIntegration integration) {
        super((JavaeeIntegration)integration);
    }

    @NotNull
    protected ServerModel createLocalModel() {
        TomcatLocalModel tomcatLocalModel = new TomcatLocalModel();
        if (tomcatLocalModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase", "createLocalModel"));
        }
        return tomcatLocalModel;
    }

    @NotNull
    protected ServerModel createRemoteModel() {
        TomcatRemoteModel tomcatRemoteModel = new TomcatRemoteModel();
        if (tomcatRemoteModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase", "createRemoteModel"));
        }
        return tomcatRemoteModel;
    }

    @NotNull
    protected ExecutableObjectStartupPolicy createStartupPolicy() {
        TomcatStartupPolicy tomcatStartupPolicy = new TomcatStartupPolicy();
        if (tomcatStartupPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase", "createStartupPolicy"));
        }
        return tomcatStartupPolicy;
    }

    public String getUrlToOpenInBrowser(@NotNull ApplicationServer server, @NotNull PsiFile psiFile) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase", "getUrlToOpenInBrowser"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/idea/tomcat/server/TomcatConfigurationBase", "getUrlToOpenInBrowser"));
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiFile);
        if (webFacet == null) {
            return null;
        }
        int port = new TomcatPersistentDataWrapper(server).getSourceLocalPort();
        String root = "http://localhost:" + port;
        String relativePath = JspDeploymentManager.getInstance().computeRelativeTargetPath(psiFile, webFacet);
        if (relativePath == null) {
            return null;
        }
        return DeploymentUtil.concatPaths((String[])new String[]{root, relativePath});
    }
}

