/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.cloud;

import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgent;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentConfig;
import com.intellij.javaee.cloudbees.cloud.CBDeploymentConfiguration;
import com.intellij.javaee.cloudbees.cloud.CBDeploymentRuntime;
import com.intellij.javaee.cloudbees.cloud.CBServerConfiguration;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.agent.DeploymentDataImpl;
import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.agent.util.CloudAgentBase;
import com.intellij.remoteServer.agent.util.CloudAgentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudApplicationRuntimeImpl;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CBServerRuntimeInstance
extends CloudServerRuntimeInstance<CBDeploymentConfiguration, CBCloudAgent, CBServerConfiguration> {
    private static final Logger LOG = Logger.getInstance(CBServerRuntimeInstance.class);
    private static final String SPECIFICS_MODULE_NAME = "CloudBeesSrv";
    private static final String SPECIFICS_JAR_PATH = "specifics/cloudBeesSpecifics.jar";

    public CBServerRuntimeInstance(@NotNull CBServerConfiguration configuration, @NotNull ServerTaskExecutor taskExecutor, @NotNull List<File> libraryFiles) throws Exception {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "<init>"));
        }
        if (taskExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskExecutor", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "<init>"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "<init>"));
        }
        super((CloudAgentConfigBase)configuration, taskExecutor, libraryFiles, Arrays.asList(DeploymentDataImpl.class, ILogger.class), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, CBCloudAgent.class, "com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentImpl");
    }

    public void connect(final ServerConnector.ConnectionCallback<CBDeploymentConfiguration> callback) {
        ((CBCloudAgent)this.getAgent()).connect((CBCloudAgentConfig)this.getConfiguration(), new CloudAgentCallback(){

            public void connected() {
                callback.connected((ServerRuntimeInstance)CBServerRuntimeInstance.this);
            }

            public void errorOccurred(String errorMessage) {
                callback.errorOccurred(errorMessage);
            }
        }, new CloudAgentLogger(){

            public void debugEx(Exception e) {
                LOG.debug((Throwable)e);
            }

            public void debug(String message) {
                LOG.debug(message);
            }
        }, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "getDeploymentName"));
        }
        String string = ((CBServerConfiguration)this.getConfiguration()).getDomainPrefix() + "/" + CBServerRuntimeInstance.getApplicationName(source);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    private static String getApplicationName(DeploymentSource source) {
        return CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(source).replace('_', '-');
    }

    public void deploy(@NotNull DeploymentTask<CBDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "deploy"));
        }
        DeploymentSource deploymentSource = task.getSource();
        File source = deploymentSource.getFile();
        if (source == null) {
            callback.errorOccurred(JavaeeBundle.getText((String)"ServerInstance.invalid.deployment.source", (Object[])new Object[]{deploymentSource.getPresentableName()}));
            return;
        }
        String deploymentName = this.getDeploymentName(deploymentSource);
        String appUrl = "http://" + CBServerRuntimeInstance.getApplicationName(deploymentSource) + "." + ((CBServerConfiguration)this.getConfiguration()).getDomainPrefix() + ".cloudbees.net";
        this.getTaskExecutor().submit(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "lambda$deploy$0"));
            }
            if (logManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "lambda$deploy$0"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/cloudbees/cloud/CBServerRuntimeInstance", "lambda$deploy$0"));
            }
            new CBDeploymentRuntime(this.getTaskExecutor(), (CBCloudAgent)this.getAgent(), deploymentName, appUrl, task, logManager).deploy(callback);
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(() -> ((CBCloudAgent)this.getAgent()).disconnect());
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        return new CloudApplicationRuntimeImpl(this.getTaskExecutor(), (CloudAgentBase)this.getAgent(), application);
    }
}

