/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.angularjs.cli.AngularJSFramework;
import org.angularjs.cli.AngularJSProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class AngularJSFrameworkDetector
extends FrameworkDetector {
    protected AngularJSFrameworkDetector() {
        super("AngularCLI");
    }

    @NotNull
    public FileType getFileType() {
        JsonFileType jsonFileType = JsonFileType.INSTANCE;
        if (jsonFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularJSFrameworkDetector", "getFileType"));
        }
        return jsonFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().withName(".angular-cli.json").with((PatternCondition)new PatternCondition<FileContent>("notLibrary"){

            public boolean accepts(@NotNull FileContent content, ProcessingContext context) {
                if (content == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/angularjs/cli/AngularJSFrameworkDetector$1", "accepts"));
                }
                return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)content.getFile());
            }
        });
        if (objectPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularJSFrameworkDetector", "createSuitableFilePattern"));
        }
        return objectPattern;
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        if (newFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFiles", "org/angularjs/cli/AngularJSFrameworkDetector", "detect"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/cli/AngularJSFrameworkDetector", "detect"));
        }
        if (newFiles.size() > 0 && !AngularJSFrameworkDetector.isConfigured(newFiles, context.getProject())) {
            return Collections.singletonList(new AngularCLIFrameworkDescription(newFiles));
        }
        return Collections.emptyList();
    }

    private static boolean isConfigured(Collection<VirtualFile> files, Project project) {
        if (project == null) {
            return false;
        }
        for (VirtualFile file : files) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null) continue;
            for (String root : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                if (!root.equals(file.getParent().getUrl() + "/tmp")) continue;
                return true;
            }
        }
        return false;
    }

    public FrameworkType getFrameworkType() {
        return AngularJSFramework.INSTANCE;
    }

    private class AngularCLIFrameworkDescription
    extends DetectedFrameworkDescription {
        private final Collection<VirtualFile> myNewFiles;

        public AngularCLIFrameworkDescription(Collection<VirtualFile> newFiles) {
            this.myNewFiles = newFiles;
        }

        @NotNull
        public Collection<? extends VirtualFile> getRelatedFiles() {
            Collection<VirtualFile> collection = this.myNewFiles;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription", "getRelatedFiles"));
            }
            return collection;
        }

        @NotNull
        public String getSetupText() {
            if ("AngularCLI" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription", "getSetupText"));
            }
            return "AngularCLI";
        }

        @NotNull
        public FrameworkDetector getDetector() {
            AngularJSFrameworkDetector angularJSFrameworkDetector = AngularJSFrameworkDetector.this;
            if (angularJSFrameworkDetector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription", "getDetector"));
            }
            return angularJSFrameworkDetector;
        }

        public void setupFramework(@NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull ModulesProvider modulesProvider) {
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription", "setupFramework"));
            }
            if (modulesProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription", "setupFramework"));
            }
            for (Module module : modulesProvider.getModules()) {
                ContentEntry entry;
                ModifiableRootModel model = modifiableModelsProvider.getModuleModifiableModel(module);
                VirtualFile item = (VirtualFile)ContainerUtil.getFirstItem(this.myNewFiles);
                ContentEntry contentEntry = entry = item != null ? MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)item) : null;
                if (entry == null) {
                    modifiableModelsProvider.disposeModuleModifiableModel(model);
                    continue;
                }
                AngularJSProjectConfigurator.excludeDefault(item.getParent(), entry);
                modifiableModelsProvider.commitModuleModifiableModel(model);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof AngularCLIFrameworkDescription && this.myNewFiles.equals(((AngularCLIFrameworkDescription)((Object)obj)).myNewFiles);
        }

        public int hashCode() {
            return this.myNewFiles.hashCode();
        }
    }
}

