/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr.dependencies;

import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.Version;
import com.intellij.spring.initializr.VersionRange;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.Nullable;

class DependenciesTable
extends JBTable {
    private static final ColoredTableCellRenderer DEPENDENCY_RENDERER = new ColoredTableCellRenderer(){

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            SpringInitializrOptions.Option option = (SpringInitializrOptions.Option)((Object)value);
            assert (option != null);
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean tableHasFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, table);
            this.setPaintFocusBorder(tableHasFocus && table.isRowSelected(row));
            boolean selectable = table.getModel().isCellEditable(row, 0);
            if (selectable) {
                this.append(option.display);
            } else {
                this.append(option.display, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
        }
    };

    DependenciesTable() {
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DependenciesTable.this.getSelectedRow() == -1) {
                    DependenciesTable.this.setRowSelectionInterval(0, 0);
                } else {
                    DependenciesTable.this.repaint(DependenciesTable.this.getVisibleRect());
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setRowMargin(0);
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        this.getActionMap().put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DependenciesTable.this.isEditing()) {
                    return;
                }
                int row = DependenciesTable.this.getSelectedRow();
                if (!DependenciesTable.this.getModel().isCellEditable(row, 0)) {
                    return;
                }
                SpeedSearchSupply speedSearch = SpeedSearchSupply.getSupply((JComponent)((Object)DependenciesTable.this));
                if (speedSearch != null) {
                    return;
                }
                boolean value = (Boolean)DependenciesTable.this.getModel().getValueAt(row, 0);
                DependenciesTable.this.getModel().setValueAt(!value, row, 0);
            }
        });
        new TableSpeedSearch((JTable)((Object)this), o -> {
            if (o instanceof SpringInitializrOptions.Option) {
                return ((SpringInitializrOptions.Option)((Object)((Object)o))).display;
            }
            return "";
        });
    }

    @Nullable
    SpringInitializrOptions.Option getSelectedValue() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (SpringInitializrOptions.Option)((Object)this.getModel().getValueAt(row, 1));
    }

    void setDependencies(Version springBootVersion, List<SpringInitializrOptions.Option> deps, Set<String> selectedDependenciesIds) {
        DependenciesTableModel model = new DependenciesTableModel(springBootVersion, selectedDependenciesIds, deps);
        this.setModel(model);
        this.setupColumns();
    }

    private void setupColumns() {
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.setColumnMargin(0);
        TableColumn checkBoxColumn = columnModel.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkBoxColumn);
        checkBoxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn dependencyColumn = columnModel.getColumn(1);
        dependencyColumn.setCellRenderer((TableCellRenderer)DEPENDENCY_RENDERER);
    }

    void updateSelection(Set<String> selectedDependenciesIds) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            String id = ((SpringInitializrOptions.Option)((Object)this.getValueAt((int)row, (int)1))).id;
            this.setValueAt(selectedDependenciesIds.contains(id), row, 0);
        }
    }

    private static class DependenciesTableModel
    extends AbstractTableModel {
        private final Set<String> mySelectedDependenciesIds;
        private final List<SpringInitializrOptions.Option> myDependencies;
        private final boolean[] myChecked;
        private final boolean[] myDisabledCheckBoxes;
        private static final int COL_CHECK = 0;
        private static final int COL_DEP = 1;

        DependenciesTableModel(Version springBootVersion, Set<String> selectedDependenciesIds, List<SpringInitializrOptions.Option> dependencies) {
            this.mySelectedDependenciesIds = selectedDependenciesIds;
            this.myDependencies = dependencies;
            this.myChecked = new boolean[this.myDependencies.size()];
            this.myDisabledCheckBoxes = new boolean[this.myDependencies.size()];
            int i = 0;
            for (SpringInitializrOptions.Option dependency : dependencies) {
                VersionRange range = (VersionRange)dependency.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
                if (range != null && !range.match(springBootVersion)) {
                    this.myDisabledCheckBoxes[i] = true;
                }
                if (selectedDependenciesIds.contains(dependency.id)) {
                    this.myChecked[i] = true;
                }
                ++i;
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && !this.myDisabledCheckBoxes[rowIndex];
        }

        @Override
        public int getRowCount() {
            return this.myDependencies.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return this.myDependencies.get(rowIndex);
            }
            return this.myChecked[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            this.myChecked[rowIndex] = (Boolean)aValue;
            boolean selected = this.myChecked[rowIndex];
            String id = this.myDependencies.get((int)rowIndex).id;
            if (selected) {
                this.mySelectedDependenciesIds.add(id);
            } else {
                this.mySelectedDependenciesIds.remove(id);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

