/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.initializr.SpringInitializrRunConfigUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=3000)
public class SpringInitializrGradleProjectDataService
extends AbstractProjectDataService<ModuleData, Void> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/gradle/SpringInitializrGradleProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void onSuccessImport(@NotNull Collection<DataNode<ModuleData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imported", "com/intellij/spring/initializr/gradle/SpringInitializrGradleProjectDataService", "onSuccessImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/initializr/gradle/SpringInitializrGradleProjectDataService", "onSuccessImport"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/spring/initializr/gradle/SpringInitializrGradleProjectDataService", "onSuccessImport"));
        }
        if (projectData == null) {
            return;
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/initializr/gradle/SpringInitializrGradleProjectDataService", "lambda$onSuccessImport$0"));
            }
            if (modelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/spring/initializr/gradle/SpringInitializrGradleProjectDataService", "lambda$onSuccessImport$0"));
            }
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
                return;
            }
            for (Module module : modelsProvider.getModules()) {
                List springBootApplications;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (rootProjectPath == null || !rootProjectPath.equals(projectData.getLinkedExternalProjectPath()) || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module) || (springBootApplications = SpringBootApplicationUtil.getSpringApplications((Module)module)).isEmpty()) continue;
                SpringInitializrRunConfigUtil runConfigUtil = new SpringInitializrRunConfigUtil(module);
                runConfigUtil.createRunConfig();
            }
        });
    }
}

