/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.imp;

import aQute.bnd.build.Workspace;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.imp.BndProjectImporter;

public class ReimportProjectsAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/osgi/bnd/imp/ReimportProjectsAction", "update"));
        }
        Workspace workspace = BndProjectImporter.getWorkspace(e.getProject());
        boolean available = workspace != null && !ReimportProjectsAction.getProjectDirs((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)).isEmpty();
        e.getPresentation().setEnabledAndVisible(available);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Collection<String> projectDirs;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/osgi/bnd/imp/ReimportProjectsAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project != null && !(projectDirs = ReimportProjectsAction.getProjectDirs((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).isEmpty()) {
            BndProjectImporter.reimportProjects(project, projectDirs);
        }
    }

    private static Collection<String> getProjectDirs(@Nullable VirtualFile[] files) {
        if (files == null || files.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList projectDirs = ContainerUtil.newArrayListWithCapacity((int)files.length);
        for (VirtualFile file : files) {
            if (!file.isInLocalFileSystem()) continue;
            if (!file.isDirectory() && "bnd.bnd".equals(file.getName())) {
                projectDirs.add(file.getParent().getPath());
                continue;
            }
            if (!file.isDirectory() || file.findChild("bnd.bnd") == null) continue;
            projectDirs.add(file.getPath());
        }
        return projectDirs;
    }
}

