/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.impl.equinox.EquinoxRunProperties;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.FrameworkRunPropertiesEditor;
import org.osmorc.run.ui.GenericRunPropertiesEditor;

public class EquinoxRunPropertiesEditor
implements FrameworkRunPropertiesEditor {
    private JPanel myMainPanel;
    private GenericRunPropertiesEditor myGenericRunPropertiesEditor;
    private JRadioButton myJustTheBundlesRadioButton;
    private JRadioButton myProductRadioButton;
    private JTextField myProductTextField;
    private JRadioButton myApplicationRadioButton;
    private JTextField myApplicationTextField;

    public EquinoxRunPropertiesEditor() {
        this.$$$setupUI$$$();
        ActionListener updater = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EquinoxRunPropertiesEditor.this.updatePresentation();
            }
        };
        this.myJustTheBundlesRadioButton.addActionListener(updater);
        this.myProductRadioButton.addActionListener(updater);
        this.myApplicationRadioButton.addActionListener(updater);
    }

    private void createUIComponents() {
        this.myGenericRunPropertiesEditor = new GenericRunPropertiesEditor();
    }

    private void updatePresentation() {
        if (this.myJustTheBundlesRadioButton.isSelected()) {
            this.myProductTextField.setText("");
            this.myProductTextField.setEnabled(false);
            this.myApplicationTextField.setText("");
            this.myApplicationTextField.setEnabled(false);
        } else if (this.myProductRadioButton.isSelected()) {
            this.myApplicationTextField.setText("");
            this.myApplicationTextField.setEnabled(false);
            this.myProductTextField.setEnabled(true);
        } else if (this.myApplicationRadioButton.isSelected()) {
            this.myProductTextField.setText("");
            this.myProductTextField.setEnabled(false);
            this.myApplicationTextField.setEnabled(true);
        }
    }

    @Override
    public JPanel getUI() {
        return this.myMainPanel;
    }

    @Override
    public void resetEditorFrom(@NotNull OsgiRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/frameworkintegration/impl/equinox/ui/EquinoxRunPropertiesEditor", "resetEditorFrom"));
        }
        this.myGenericRunPropertiesEditor.resetEditorFrom(runConfiguration);
        Map<String, String> properties = runConfiguration.getAdditionalProperties();
        String product = EquinoxRunProperties.getEquinoxProduct(properties);
        String application = EquinoxRunProperties.getEquinoxApplication(properties);
        if (!StringUtil.isEmptyOrSpaces((String)product)) {
            this.myProductRadioButton.setSelected(true);
            this.myProductTextField.setText(product);
        } else if (!StringUtil.isEmptyOrSpaces((String)application)) {
            this.myApplicationRadioButton.setSelected(true);
            this.myApplicationTextField.setText(application);
        } else {
            this.myJustTheBundlesRadioButton.setSelected(true);
        }
        this.updatePresentation();
    }

    @Override
    public void applyEditorTo(@NotNull OsgiRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/frameworkintegration/impl/equinox/ui/EquinoxRunPropertiesEditor", "applyEditorTo"));
        }
        this.myGenericRunPropertiesEditor.applyEditorTo(runConfiguration);
        HashMap properties = ContainerUtil.newHashMap();
        EquinoxRunProperties.setEquinoxProduct(properties, this.myProductTextField.getText());
        EquinoxRunProperties.setEquinoxApplication(properties, this.myApplicationTextField.getText());
        runConfiguration.putAdditionalProperties(properties);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JTextField jTextField2;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        GenericRunPropertiesEditor genericRunPropertiesEditor = this.myGenericRunPropertiesEditor;
        JComponent jComponent = genericRunPropertiesEditor.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 6, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Run", (int)0, (int)0, null, null));
        this.myJustTheBundlesRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Just the bundles");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myProductRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Product");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProductTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myApplicationRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Application");
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

