/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.facet;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.osgi.jps.build.FakeAnalyzer;
import org.osmorc.OsmorcProjectComponent;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.maven.facet.DependencyEmbedder;
import org.osmorc.maven.facet.DependencyEmbedderException;
import org.osmorc.maven.facet.ResourceCollector;

public class ImporterUtil {
    private static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    private ImporterUtil() {
    }

    @NotNull
    static String removeTagFromInstruction(@NotNull String instruction, @NotNull String tag) {
        String[] clauses;
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/osmorc/maven/facet/ImporterUtil", "removeTagFromInstruction"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/osmorc/maven/facet/ImporterUtil", "removeTagFromInstruction"));
        }
        StringBuilder buf = new StringBuilder();
        for (String clause1 : clauses = instruction.split(",")) {
            String clause = clause1.trim();
            if (tag.equals(clause)) continue;
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(clause);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/ImporterUtil", "removeTagFromInstruction"));
        }
        return string;
    }

    @NotNull
    static Collection<MavenArtifact> collectDependencies(@NotNull Map<String, String> props, @NotNull MavenProject project) {
        Collection<Object> dependencies;
        if (props == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props", "org/osmorc/maven/facet/ImporterUtil", "collectDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/maven/facet/ImporterUtil", "collectDependencies"));
        }
        if (Boolean.parseBoolean(props.get("Embed-Transitive"))) {
            HashSet<MavenArtifact> processed = new HashSet<MavenArtifact>();
            LinkedList nodes = new LinkedList(project.getDependencyTree());
            while (!nodes.isEmpty()) {
                MavenArtifactNode node = (MavenArtifactNode)nodes.pop();
                MavenArtifact artifact = node.getArtifact();
                if (processed.contains(artifact)) continue;
                processed.add(artifact);
                nodes.addAll(node.getDependencies());
            }
            dependencies = processed;
        } else {
            dependencies = project.getDependencies();
        }
        List list = dependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/ImporterUtil", "collectDependencies"));
        }
        return list;
    }

    static String cleanupVersion(String version) {
        StringBuffer result = new StringBuffer();
        Matcher m = FUZZY_VERSION.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            ImporterUtil.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        ImporterUtil.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    ImporterUtil.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            ImporterUtil.cleanupModifier(result, version);
        }
        return result.toString();
    }

    private static void cleanupModifier(StringBuffer result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    static void postProcessAdditionalProperties(@NotNull Map<String, String> props, @NotNull MavenProject mavenProject, @NotNull Project project) {
        if (props == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props", "org/osmorc/maven/facet/ImporterUtil", "postProcessAdditionalProperties"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/osmorc/maven/facet/ImporterUtil", "postProcessAdditionalProperties"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/maven/facet/ImporterUtil", "postProcessAdditionalProperties"));
        }
        FakeAnalyzer analyzer = new FakeAnalyzer(props);
        Collection<MavenArtifact> dependencies = ImporterUtil.collectDependencies(props, mavenProject);
        DependencyEmbedder embedder = new DependencyEmbedder(dependencies);
        try {
            embedder.processHeaders((Analyzer)analyzer);
        }
        catch (DependencyEmbedderException e) {
            String message = OsmorcBundle.message("maven.import.embed.error", mavenProject.getPath(), e.getMessage());
            OsmorcProjectComponent.IMPORTANT_NOTIFICATIONS.createNotification(message, NotificationType.ERROR).notify(project);
        }
        ResourceCollector.includeMavenResources(mavenProject, (Analyzer)analyzer);
        ImporterUtil.sanitizeIncludedResources(props, mavenProject);
    }

    private static void sanitizeIncludedResources(@NotNull Map<String, String> props, @NotNull MavenProject project) {
        if (props == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props", "org/osmorc/maven/facet/ImporterUtil", "sanitizeIncludedResources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/maven/facet/ImporterUtil", "sanitizeIncludedResources"));
        }
        String includeResourceHeader = props.get("Include-Resource");
        if (StringUtil.isEmpty((String)includeResourceHeader)) {
            return;
        }
        Parameters parameters = OSGiHeader.parseHeader((String)includeResourceHeader);
        StringBuilder sanitizedHeader = new StringBuilder();
        Iterator iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String prefix = "";
            String suffix = "";
            if (StringUtil.startsWithChar((CharSequence)name, (char)'{') && name.endsWith("}")) {
                name = name.substring(1, name.length() - 1).trim();
                prefix = "{" + prefix;
                suffix = suffix + "}";
            }
            String[] parts = name.split("\\s*=\\s*");
            String source = parts[0];
            String target = "";
            if (parts.length == 2) {
                source = parts[1];
                target = parts[0];
            }
            if (StringUtil.startsWithChar((CharSequence)source, (char)'@')) {
                source = source.substring(1);
                prefix = prefix + "@";
            }
            String sanitizedSource = source.replace('\\', '/');
            String sanitizedTarget = target.replace('\\', '/');
            VirtualFile relativeFile = VfsUtil.findRelativeFile((VirtualFile)project.getDirectoryFile(), (String[])sanitizedSource.split("/"));
            if (relativeFile != null) {
                sanitizedSource = relativeFile.getPath();
            }
            sanitizedHeader.append(prefix);
            if (!StringUtil.isEmpty((String)sanitizedTarget)) {
                sanitizedHeader.append(sanitizedTarget).append("=");
            }
            sanitizedHeader.append(sanitizedSource);
            sanitizedHeader.append(suffix);
            if (!iterator.hasNext()) continue;
            sanitizedHeader.append(",");
        }
        props.put("Include-Resource", sanitizedHeader.toString());
    }
}

