/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="StructuralSearchPlugin", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationManager
implements PersistentStateComponent<Element> {
    @NonNls
    static final String SEARCH_TAG_NAME = "searchConfiguration";
    @NonNls
    static final String REPLACE_TAG_NAME = "replaceConfiguration";
    @NonNls
    private static final String SAVE_HISTORY_ATTR_NAME = "history";
    private final List<Configuration> configurations = new SmartList();
    private final List<Configuration> historyConfigurations = new SmartList();

    public static ConfigurationManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "getInstance"));
        }
        return (ConfigurationManager)ServiceManager.getService((Project)project, ConfigurationManager.class);
    }

    public Element getState() {
        Element state = new Element("state");
        ConfigurationManager.writeConfigurations(state, this.configurations, this.historyConfigurations);
        return state;
    }

    public void loadState(Element state) {
        this.configurations.clear();
        this.historyConfigurations.clear();
        ConfigurationManager.readConfigurations(state, this.configurations, this.historyConfigurations);
    }

    public void addHistoryConfigurationToFront(Configuration configuration) {
        this.historyConfigurations.remove(configuration);
        this.historyConfigurations.add(0, configuration);
        configuration.setCreated(System.currentTimeMillis());
    }

    public void removeHistoryConfiguration(Configuration configuration) {
        this.historyConfigurations.remove(configuration);
    }

    public void addConfiguration(Configuration configuration) {
        this.configurations.remove(configuration);
        this.configurations.add(configuration);
    }

    public void removeConfiguration(Configuration configuration) {
        this.configurations.remove(configuration);
    }

    public static void writeConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "writeConfigurations"));
        }
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "writeConfigurations"));
        }
        if (historyConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyConfigurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "writeConfigurations"));
        }
        for (Configuration configuration : configurations) {
            ConfigurationManager.saveConfiguration(element, configuration);
        }
        for (Configuration historyConfiguration : historyConfigurations) {
            Element infoElement = ConfigurationManager.saveConfiguration(element, historyConfiguration);
            infoElement.setAttribute(SAVE_HISTORY_ATTR_NAME, "1");
        }
    }

    private static Element saveConfiguration(@NotNull Element element, @NotNull Configuration config) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "saveConfiguration"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "saveConfiguration"));
        }
        Element infoElement = new Element(config instanceof SearchConfiguration ? SEARCH_TAG_NAME : REPLACE_TAG_NAME);
        element.addContent(infoElement);
        config.writeExternal(infoElement);
        return infoElement;
    }

    public static void readConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "readConfigurations"));
        }
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "readConfigurations"));
        }
        if (historyConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyConfigurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "readConfigurations"));
        }
        for (Element pattern : element.getChildren()) {
            Configuration config = ConfigurationManager.readConfiguration(pattern);
            if (config == null) continue;
            if (pattern.getAttribute(SAVE_HISTORY_ATTR_NAME) != null) {
                historyConfigurations.add(config);
                continue;
            }
            configurations.add(config);
        }
    }

    private static Configuration readConfiguration(@NotNull Element childElement) {
        Configuration config;
        if (childElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childElement", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "readConfiguration"));
        }
        String name = childElement.getName();
        if (name.equals(SEARCH_TAG_NAME)) {
            config = new SearchConfiguration();
        } else if (name.equals(REPLACE_TAG_NAME)) {
            config = new ReplaceConfiguration();
        } else {
            return null;
        }
        ((Configuration)config).readExternal(childElement);
        return config;
    }

    @NotNull
    public Collection<Configuration> getConfigurations() {
        List<Configuration> list = Collections.unmodifiableList(this.configurations);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "getConfigurations"));
        }
        return list;
    }

    @Nullable
    public Configuration findConfigurationByName(String name) {
        Configuration configuration = ConfigurationManager.findConfigurationByName(this.configurations, name);
        if (configuration != null) {
            return configuration;
        }
        return ConfigurationManager.findConfigurationByName(StructuralSearchUtil.getPredefinedTemplates(), name);
    }

    @Nullable
    private static Configuration findConfigurationByName(Collection<Configuration> configurations, String name) {
        for (Configuration config : configurations) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    @NotNull
    public Collection<Configuration> getHistoryConfigurations() {
        List<Configuration> list = Collections.unmodifiableList(this.historyConfigurations);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "getHistoryConfigurations"));
        }
        return list;
    }

    @Nullable
    public static String findAppropriateName(@NotNull Collection<Configuration> configurations, @NotNull String _name, @NotNull Project project) {
        Configuration config;
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "findAppropriateName"));
        }
        if (_name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_name", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "findAppropriateName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "findAppropriateName"));
        }
        String name = _name;
        while ((config = ConfigurationManager.findConfigurationByName(configurations, name)) != null) {
            int i = Messages.showYesNoDialog((Project)project, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", new Object[0]), (Icon)AllIcons.General.QuestionDialog);
            if (i == 0) {
                configurations.remove(config);
                break;
            }
            if ((name = ConfigurationManager.showSaveTemplateAsDialog(name, project)) != null) continue;
            break;
        }
        return name;
    }

    @Nullable
    public static String showSaveTemplateAsDialog(@NotNull String initial, @NotNull Project project) {
        if (initial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "showSaveTemplateAsDialog"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager", "showSaveTemplateAsDialog"));
        }
        return Messages.showInputDialog((Project)project, (String)SSRBundle.message("template.name.button", new Object[0]), (String)SSRBundle.message("save.template.description.button", new Object[0]), (Icon)AllIcons.General.QuestionDialog, (String)initial, (InputValidator)new NonEmptyInputValidator());
    }
}

