/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.introduce;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.introduce.SassScssPlacingIntroduceVariableType;

public class SCSSIntroduceDialog
extends DialogWrapper {
    private final Project myProject;
    private final int myOccurrencesCount;
    private JPanel myContentPane;
    private ComboBox myNameComboBox;
    private ComboBox myPlacingTypeComboBox;
    private JCheckBox myCheckBox;
    private JLabel myNameLabel;
    private JLabel myErrorLabel;
    private JLabel myPlaceLabel;
    private final String myHelpId;
    private Set<String> myAlreadyExistNames;
    private SassScssPlacingIntroduceVariableType myPlacingType;

    public SCSSIntroduceDialog(@NotNull Project project, String caption, String helpId, int occurrencesCount, List<String> possibleNames, Set<String> alreadyExistNames, SassScssPlacingIntroduceVariableType placingType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/scss/introduce/SCSSIntroduceDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myAlreadyExistNames = alreadyExistNames;
        this.myOccurrencesCount = occurrencesCount;
        this.myHelpId = helpId;
        this.myPlacingType = placingType;
        this.$$$setupUI$$$();
        this.setUpNameComboBox(possibleNames);
        this.setUpPlacingComboBox(placingType);
        this.setModal(true);
        this.setTitle(caption);
        this.init();
        this.setUpDialog();
        this.updateControls();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    public String getName() {
        Object s = this.myNameComboBox.getEditor().getItem();
        if (s instanceof String && ((String)s).length() > 0) {
            return ((String)s).trim();
        }
        return null;
    }

    public SassScssPlacingIntroduceVariableType getPlacingType() {
        return this.myPlacingType;
    }

    public boolean doReplaceAllOccurrences() {
        return this.myCheckBox.isSelected();
    }

    private void setUpDialog() {
        this.myCheckBox.setMnemonic(65);
        this.myNameLabel.setLabelFor((Component)this.myNameComboBox);
        if (this.myOccurrencesCount > 1) {
            this.myCheckBox.setSelected(false);
            this.myCheckBox.setEnabled(true);
            this.myCheckBox.setText(this.myCheckBox.getText() + " (" + this.myOccurrencesCount + " occurrences)");
        } else {
            this.myCheckBox.setSelected(false);
            this.myCheckBox.setEnabled(false);
        }
    }

    private void setUpPlacingComboBox(SassScssPlacingIntroduceVariableType type) {
        this.myPlacingTypeComboBox.setEditable(false);
        for (SassScssPlacingIntroduceVariableType variableType : SassScssPlacingIntroduceVariableType.values()) {
            this.myPlacingTypeComboBox.addItem((Object)variableType);
        }
        this.myPlaceLabel.setLabelFor((Component)this.myPlacingTypeComboBox);
        this.myPlacingTypeComboBox.setSelectedItem((Object)type);
        this.myPlacingTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SCSSIntroduceDialog.this.myPlacingType = (SassScssPlacingIntroduceVariableType)((Object)e.getItem());
            }
        });
        this.myContentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)SCSSIntroduceDialog.this.myPlacingTypeComboBox, true));
            }
        }, KeyStroke.getKeyStroke(80, 8), 2);
    }

    private void setUpNameComboBox(List<String> possibleNames) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)SCSSFileType.SCSS, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SCSSIntroduceDialog.this.updateControls();
            }
        });
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                SCSSIntroduceDialog.this.updateControls();
            }
        });
        this.myContentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)SCSSIntroduceDialog.this.myNameComboBox, true));
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        for (String possibleName : possibleNames) {
            this.myNameComboBox.addItem((Object)possibleName);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/introduce/SCSSIntroduceDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpId);
    }

    protected void updateControls() {
        String name = this.getName();
        boolean nameUsed = this.myAlreadyExistNames.contains(name != null && StringUtil.startsWithChar((CharSequence)name, (char)'$') ? name.substring(1) : name);
        boolean nameValid = name != null && SASSSCSSLangUtil.isValidVariableName(name) && !nameUsed;
        this.setOKActionEnabled(nameValid);
        if (!nameValid) {
            this.myErrorLabel.setText(nameUsed ? RefactoringBundle.message((String)"refactoring.introduce.name.used.error") : RefactoringBundle.message((String)"refactoring.introduce.name.error"));
            return;
        }
        this.myErrorLabel.setText(" ");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        ComboBox comboBox;
        JLabel jLabel2;
        JLabel jLabel3;
        ComboBox comboBox2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameComboBox = comboBox2 = new ComboBox();
        comboBox2.setLightWeightPopupEnabled(true);
        comboBox2.setEditable(true);
        jPanel2.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("<HTML><u>N</u>ame:");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setForeground(new Color(-65536));
        jLabel2.setText("some error message here");
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 0, new Dimension(320, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPlacingTypeComboBox = comboBox = new ComboBox();
        comboBox.setLightWeightPopupEnabled(true);
        comboBox.setEditable(false);
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPlaceLabel = jLabel = new JLabel();
        jLabel.setText("<HTML><u>P</u>lace for declaration:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setText("Replace all occurrences");
        jCheckBox.setMnemonic('A');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

