/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ModuleSettings;
import com.intellij.javaee.converting.artifacts.AbstractPackagingConverter;
import com.intellij.javaee.converting.artifacts.ContainerElementProcessor;
import com.intellij.javaee.converting.artifacts.PackagingConversionUtil;
import com.intellij.javaee.converting.artifacts.PackagingMethod;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ContainerElementProcessorBase<C extends AbstractPackagingConverter>
extends ContainerElementProcessor {
    protected final Element myRoot;
    protected final Element myExternal;
    protected final ModuleSettings myModuleSettings;
    protected final C myConverter;

    ContainerElementProcessorBase(Element root, Element external, ModuleSettings moduleSettings, C converter) {
        this.myRoot = root;
        this.myExternal = external;
        this.myModuleSettings = moduleSettings;
        this.myConverter = converter;
    }

    protected void addToClasspath(PackagingMethod packagingMethod, String outputPath) {
        if (PackagingConversionUtil.isExternal(packagingMethod)) {
            this.getOrCreateClasspath().add(StringUtil.trimStart((String)outputPath, (String)"/"));
        }
    }

    protected abstract List<String> getOrCreateClasspath();

    @Override
    public void processLibraryLink(@NotNull String libraryName, @NotNull String level, @Nullable String moduleName, @NotNull String outputPath, @NotNull PackagingMethod packagingMethod) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryLink"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryLink"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryLink"));
        }
        if (packagingMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagingMethod", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryLink"));
        }
        if (PackagingConversionUtil.isJar(packagingMethod)) {
            this.addToClasspath(packagingMethod, outputPath);
        } else {
            ModuleSettings moduleSettings;
            String parentPath;
            if (outputPath.endsWith(".jar") && (parentPath = PathUtil.getParentPath((String)outputPath)).length() > 0) {
                outputPath = parentPath;
            }
            ConversionContext context = ((AbstractPackagingConverter)((Object)this.myConverter)).getContext();
            List roots = moduleName == null ? context.getLibraryClassRoots(libraryName, level) : ((moduleSettings = context.getModuleSettings(moduleName)) != null ? moduleSettings.getModuleLibraryRoots(libraryName) : Collections.emptyList());
            for (File root : roots) {
                this.addToClasspath(packagingMethod, DeploymentUtil.appendToPath((String)outputPath, (String)root.getName()));
            }
        }
        Element parent = PackagingConversionUtil.getOrCreateParent(this.myRoot, this.myExternal, outputPath, packagingMethod);
        PackagingConversionUtil.addLibrary(parent, libraryName, level, moduleName);
    }

    @Override
    public void processLibraryFile(@NotNull String filePath, @NotNull String outputPath, @NotNull PackagingMethod packagingMethod) {
        String parentPath;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryFile"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryFile"));
        }
        if (packagingMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagingMethod", "com/intellij/javaee/converting/artifacts/ContainerElementProcessorBase", "processLibraryFile"));
        }
        filePath = ((AbstractPackagingConverter)((Object)this.myConverter)).expandModuleMacros(filePath, this.myModuleSettings);
        String fileName = null;
        if (!PackagingConversionUtil.isJar(packagingMethod) && outputPath.endsWith(".jar")) {
            parentPath = PathUtil.getParentPath((String)outputPath);
            String outputFileName = PathUtil.getFileName((String)outputPath);
            if (!PathUtil.getFileName((String)filePath).equals(outputFileName)) {
                fileName = outputFileName;
            }
        } else {
            parentPath = outputPath;
        }
        File file = new File(FileUtil.toSystemDependentName((String)this.myModuleSettings.expandPath(filePath)));
        String classpathItem = PackagingConversionUtil.isJar(packagingMethod) ? outputPath : (file.isDirectory() ? parentPath : DeploymentUtil.appendToPath((String)parentPath, (String)(fileName != null ? fileName : PathUtil.getFileName((String)filePath))));
        this.addToClasspath(packagingMethod, classpathItem);
        Element parent = PackagingConversionUtil.getOrCreateParent(this.myRoot, this.myExternal, parentPath, packagingMethod);
        if (file.isDirectory()) {
            PackagingConversionUtil.addDirectoryCopy(parent, filePath);
        } else {
            PackagingConversionUtil.addFileCopy(parent, filePath, fileName);
        }
    }
}

