/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.moduleLevel;

import com.intellij.ide.DataManager;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFileImpl;
import com.intellij.javaee.module.view.ejb.nodes.EjbNodeDescriptor;
import com.intellij.javaee.ui.DefaultUserResponse;
import com.intellij.javaee.ui.TableWithCRUDButtons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class EjbModuleEjbListPanel
extends TableWithCRUDButtons {
    private final EjbFacet myEjbFacet;
    private final DefaultTableModel myTableModel;

    public EjbModuleEjbListPanel(EjbFacet ejbFacet) {
        super(ejbFacet.getModule().getProject(), true, true);
        this.myEjbFacet = ejbFacet;
        this.myTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            public Class getColumnClass(int columnIndex) {
                return EnterpriseBean.class;
            }

            @Override
            public String getColumnName(int column) {
                return null;
            }
        };
        this.refreshModel();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.setDefaultRenderer(EnterpriseBean.class, (TableCellRenderer)new StripeTableCellRenderer((TableCellRenderer)new MyTableCellRenderer()));
        this.myTable.setRowHeight(JavaeeIcons.ENTITY_BEAN.getIconHeight());
    }

    protected void doEdit() {
        EjbAsVirtualFileImpl file;
        EnterpriseBean selectedEjb = this.getSelectedEjb();
        if (selectedEjb != null && (file = EjbAsVirtualFileImpl.findFile(selectedEjb)) != null) {
            OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(this.myProject, (VirtualFile)file);
            FileEditorManager.getInstance((Project)this.myProject).openTextEditor(fileDescriptor, true);
        }
    }

    private EnterpriseBean getSelectedEjb() {
        return (EnterpriseBean)this.getSelectedValue();
    }

    protected boolean isRemoveOk() {
        return true;
    }

    protected void doRemove() {
        EnterpriseBean selectedEjb = this.getSelectedEjb();
        if (selectedEjb != null) {
            EjbUtil.deleteModelElement((JavaeeModelElement)selectedEjb, (JamUserResponse)new DefaultUserResponse(this.myProject));
        }
    }

    protected void doNew() {
        ActionGroup group = EjbHelper.getEjbHelper().createAddEjbActionGroup(this.myEjbFacet);
        AnActionButton addButton = ToolbarDecorator.findAddButton((JComponent)this.getComponent());
        if (addButton != null) {
            JBPopupFactory.getInstance().createActionGroupPopup(null, group, DataManager.getInstance().getDataContext((Component)addButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.NUMBERING, true).show(addButton.getPreferredPopupPoint());
        }
    }

    protected void refreshModelImpl() {
        this.myTableModel.setRowCount(0);
        for (EnterpriseBean ejb : EjbCommonModelUtil.getAllEjbs((Project)this.myProject, null, (EjbFacet)this.myEjbFacet)) {
            this.myTableModel.addRow(new EnterpriseBean[]{ejb});
        }
    }

    protected String getHelpID() {
        return "newEJBedit_module_main";
    }

    private static class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            EnterpriseBean ejb = (EnterpriseBean)value;
            if (ejb == null) {
                return this;
            }
            this.setIcon(EjbNodeDescriptor.getEjbIcon(ejb));
            String name = (String)ejb.getEjbName().getValue();
            this.setText(name);
            String tooltipText = "EJB " + name;
            this.setToolTipText(tooltipText);
            return this;
        }
    }
}

