/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.descriptor;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptor;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ClassMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeDescriptorsManager {
    private static final Logger LOG = Logger.getInstance(JavaeeDescriptorsManager.class);
    private ClassMap<JavaeeDescriptor> myRootElementClass2Descriptor;
    private final JavaeeIntegration myIntegration;

    public JavaeeDescriptorsManager(JavaeeIntegration integration) {
        this.myIntegration = integration;
        this.myRootElementClass2Descriptor = new ClassMap();
    }

    public Collection<JavaeeDescriptor> getItems() {
        return this.myRootElementClass2Descriptor.values();
    }

    public void addItem(@NotNull Class<? extends JavaeeDescriptor> descriptorClass, @NotNull Class<? extends JavaeeDomModelElement> rootElementClass, @NonNls String rootTagName) {
        if (descriptorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorClass", "com/intellij/javaee/oss/descriptor/JavaeeDescriptorsManager", "addItem"));
        }
        if (rootElementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementClass", "com/intellij/javaee/oss/descriptor/JavaeeDescriptorsManager", "addItem"));
        }
        try {
            Constructor<? extends JavaeeDescriptor> descriptorConstructor = descriptorClass.getConstructor(JavaeeIntegration.class, Class.class, String.class);
            JavaeeDescriptor descriptor = descriptorConstructor.newInstance(new Object[]{this.myIntegration, rootElementClass, rootTagName});
            this.myRootElementClass2Descriptor.put(rootElementClass, (Object)descriptor);
        }
        catch (InstantiationException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
    }

    public JavaeeDescriptor getItem(Class<? extends JavaeeDomModelElement> rootClass) {
        return (JavaeeDescriptor)this.myRootElementClass2Descriptor.get(rootClass);
    }

    @Nullable
    public <T extends JavaeeDomModelElement> T getRootElement(Class<T> rootClass, JavaeeFacet f) {
        return (T)((JavaeeDomModelElement)this.getItem(rootClass).getRoot(f, rootClass));
    }
}

