/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.editor;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.module.view.AbstractJavaeeFileEditorProvider;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.DomFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeRootProvider<T extends JavaeeDomModelElement, F extends JavaeeFacet>
extends AbstractJavaeeFileEditorProvider<T, F> {
    private final JavaeeIntegration myIntegration;
    private final double myWeight;

    protected JavaeeRootProvider(Class<T> type, FacetTypeId<F> facet, JavaeeIntegration integration, double weight) {
        super(type, facet);
        this.myIntegration = integration;
        this.myWeight = weight;
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    public double getWeight() {
        return this.myWeight;
    }

    protected String getTitle() {
        return JavaeeBundle.getText("Editor.title", this.getIntegration().getName());
    }

    @Override
    @NotNull
    protected PerspectiveFileEditor createEditor(@NotNull T root, @NotNull F facet) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javaee/oss/editor/JavaeeRootProvider", "createEditor"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/oss/editor/JavaeeRootProvider", "createEditor"));
        }
        DomFileEditor domFileEditor = DomFileEditor.createDomFileEditor((String)this.getTitle(), (Icon)this.getIntegration().getBigIcon(), root, () -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javaee/oss/editor/JavaeeRootProvider", "lambda$createEditor$0"));
            }
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/oss/editor/JavaeeRootProvider", "lambda$createEditor$0"));
            }
            return this.createPanel(root, facet);
        });
        if (domFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/editor/JavaeeRootProvider", "createEditor"));
        }
        return domFileEditor;
    }

    protected abstract CommittablePanel createPanel(@NotNull T var1, @NotNull F var2);
}

