/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.jpa.model.manipulators.DefaultUserResponse;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaMissingIdInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.object.missing.id", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaMissingIdInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaMissingIdInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaMissingIdInspection", "getShortName"));
        }
        return "JpaMissingIdInspection";
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        PersistentObject object = role.getPersistentObject();
        if (object != null && role.getType() == PersistenceClassRoleEnum.ENTITY) {
            JpaMissingIdInspection.checkObjectHasId(aClass, (PersistentEntity)object, role, holder);
        }
    }

    protected static void checkObjectHasId(PsiClass aClass, PersistentEntity object, PersistenceClassRole role, ProblemsHolder holder) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
        CommonProcessors.FindProcessor<PersistentAttribute> idSearcher = new CommonProcessors.FindProcessor<PersistentAttribute>(){

            protected boolean accept(PersistentAttribute persistentAttribute) {
                return persistentAttribute.getAttributeModelHelper().isIdAttribute();
            }
        };
        browser.queryAttributes((PersistentObject)object).forEach((Processor)idSearcher);
        if (idSearcher.isFound()) {
            return;
        }
        holder.registerProblem((PsiElement)aClass.getContainingFile(), HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aClass), JpaHighlightingMessages.message("persistent.entity.0.should.have.id", object.getName().getValue()), new LocalQuickFix[]{JpaMissingIdInspection.createIdFix(role)});
    }

    private static LocalQuickFix createIdFix(final PersistenceClassRole role) {
        return new IntentionAndQuickFixAction(){

            @NotNull
            public String getName() {
                String string = this.getFamilyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaMissingIdInspection$2", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                if ("Add Id Attribute" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaMissingIdInspection$2", "getFamilyName"));
                }
                return "Add Id Attribute";
            }

            public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/inspections/JpaMissingIdInspection$2", "applyFix"));
                }
                JpaMissingIdInspection.addIdAttribute(role);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    private static void addIdAttribute(PersistenceClassRole role) {
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)role.getPersistentObject(), PersistentObjectManipulator.class);
        if (manipulator == null) {
            return;
        }
        String title = "Add Id Attribute";
        UserResponse.AttributeInfo attributeInfo = new DefaultUserResponse().getAttributeName(role.getPersistentObject(), (PersistentAttributeType)JpaAttributeType.ID, null, role.getFacet().getModelValidator(role.getPersistenceUnit()), "Add Id Attribute", "id");
        if (attributeInfo == null) {
            return;
        }
        ArrayList affectedElements = new ArrayList();
        manipulator.addAffectedElements(affectedElements);
        Ref indicatorRef = Ref.create(null);
        PersistenceHelper.getHelper().runCompositeWriteCommandAction(role.getFacet().getModule().getProject(), "Add Id Attribute", affectedElements, indicatorRef, new Runnable[]{() -> {
            try {
                manipulator.addIdAttribute(false, attributeInfo.name, attributeInfo.type, attributeInfo.fieldAccess ? PropertyMemberType.FIELD : PropertyMemberType.GETTER, Collections.emptyList());
            }
            catch (IncorrectOperationException e1) {
                throw new RuntimeException(e1);
            }
        }});
    }
}

