/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.ManualModelMergerUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.helpers.PersistentObjectModelHelper;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentObjectImpl
extends CommonModelElement.PsiBase
implements com.intellij.javaee.model.common.persistence.mapping.PersistentObject,
PersistentObjectModelHelper,
JamElement {
    public static final JamEnumAttributeMeta.Single<AccessType> ACCESS_VALUE_ATTR_META = JamAttributeMeta.singleEnum((String)"value", AccessType.class);
    public static final JamAnnotationMeta ACCESS_ANNO_META = new JamAnnotationMeta("javax.persistence.Access").addAttribute(ACCESS_VALUE_ATTR_META);
    public static final JamMemberArchetype<PsiClass, PersistentObjectImpl> PERSISTENT_OBJECT_ARCHETYPE = new JamMemberArchetype(null).addAnnotation(ACCESS_ANNO_META);
    private final PsiClass myPsiClass;
    private final AccessType myAccessType;
    private final CachedValue<PropertyMemberType> myDefaultAccessModeValue;

    protected PersistentObjectImpl(PsiClass psiClass) {
        this.myPsiClass = psiClass;
        this.myAccessType = PersistentObjectImpl.calculateAccessType(psiClass);
        this.myDefaultAccessModeValue = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)this.calcDefaultAccessMode(), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false);
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl", "getPsiElement"));
        }
        return psiClass;
    }

    public abstract JamClassMeta<? extends PersistentObjectImpl> getJamMeta();

    protected abstract PsiElementRef<PsiAnnotation> getAnnoRef();

    public boolean isValid() {
        try {
            return super.isValid() && Comparing.equal((Object)this.getJamMeta().getJamElement((PsiModifierListOwner)this.getPsiClass()), (Object)((Object)this));
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Nullable
    public AccessType getEffectiveAccessType() {
        return (AccessType)ACCESS_VALUE_ATTR_META.getJam(ACCESS_ANNO_META.getAnnotationRef((PsiModifierListOwner)this.getPsiClass()), (Enum)this.myAccessType).getValue();
    }

    public GenericValue<PsiClass> getClazz() {
        return AnnotationGenericValue.getInstance(this.getPsiClass(), (PsiAnnotation)this.getAnnoRef().getPsiElement(), null);
    }

    public List<JamAttributeBase> getAllAttributes() {
        return JamService.getJamService((Project)this.myPsiClass.getProject()).getAnnotatedMembersList(this.myPsiClass, false, true, true, false, AttributeType.getAllJamMetas());
    }

    @NotNull
    public PersistentObjectModelHelper getObjectModelHelper() {
        PersistentObjectImpl persistentObjectImpl = this;
        if (persistentObjectImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl", "getObjectModelHelper"));
        }
        return persistentObjectImpl;
    }

    @NotNull
    public List<? extends PersistentAttribute> getAttributes() {
        List<JamAttributeBase> list = this.getAllAttributes();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl", "getAttributes"));
        }
        return list;
    }

    public PropertyMemberType getDefaultAccessMode() {
        return (PropertyMemberType)this.myDefaultAccessModeValue.getValue();
    }

    private PropertyMemberType calcDefaultAccessMode() {
        PersistentObject object;
        AccessType effectiveAccessType = null;
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)this.getPsiElement());
        Iterator iterator = browser.queryPersistentObjectHierarchy((PersistentObject)this).findAll().iterator();
        while (iterator.hasNext() && (effectiveAccessType = (AccessType)ManualModelMergerUtil.findLast((List)((List)ModelMergerUtil.getImplementations((Object)(object = (PersistentObject)iterator.next()), com.intellij.javaee.model.common.persistence.mapping.PersistentObject.class)), (Function)((NullableFunction)o -> o.getEffectiveAccessType()), null)) == null) {
        }
        if (effectiveAccessType != null) {
            return effectiveAccessType == AccessType.FIELD ? PropertyMemberType.FIELD : PropertyMemberType.GETTER;
        }
        PropertyMemberType defaultAccess = (PropertyMemberType)PersistentObjectImpl.getCurrentValueOrDefault(AnnotationGenericValue.nullInstance(), persistencePackageDefaults -> persistencePackageDefaults.getAccess(), this.getPsiClass()).getValue();
        return defaultAccess == null ? PropertyMemberType.GETTER : defaultAccess;
    }

    public boolean isAccessModeFixed() {
        return this.getEffectiveAccessType() != null;
    }

    static <T> GenericValue<T> getCurrentValueOrDefault(GenericValue<T> currentValue, NullableFunction<PersistencePackageDefaults, T> processor, PsiClass psiClass) {
        if (currentValue.getValue() != null) {
            return currentValue;
        }
        if (psiClass == null) {
            return currentValue;
        }
        T value3 = PersistentObjectImpl.getDefaultValue((PsiMember)psiClass, processor);
        if (value3 != null) {
            return ReadOnlyGenericValue.getInstance(value3);
        }
        return currentValue;
    }

    @Nullable
    public static <T> T getDefaultValue(PsiMember psiMember, NullableFunction<PersistencePackageDefaults, T> processor) {
        PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
            PersistencePackageDefaults defaults;
            Object t;
            if (role.getPersistentObject() == null || (t = processor.fun((Object)(defaults = role.getFacet().getPersistenceUnitDefaults(role.getPersistenceUnit())))) == null) continue;
            return (T)t;
        }
        return null;
    }

    @Nullable
    private static AccessType calculateAccessType(PsiClass aClass) {
        for (PsiField psiField : aClass.getFields()) {
            if (psiField.hasModifierProperty("static") || psiField.hasModifierProperty("transient") || !PersistentObjectImpl.isJpaAnnotated((PsiMember)psiField)) continue;
            return AccessType.FIELD;
        }
        for (PsiField psiField : aClass.getMethods()) {
            if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)psiField) || !PersistentObjectImpl.isJpaAnnotated((PsiMember)psiField)) continue;
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static boolean isJpaAnnotated(PsiMember member) {
        PsiModifierList list = member.getModifierList();
        if (list == null) {
            return false;
        }
        for (PsiAnnotation annotation : list.getAnnotations()) {
            String qName = annotation.getQualifiedName();
            if (qName == null || qName.equals("javax.persistence.Transient") || !qName.startsWith("javax.persistence.")) continue;
            return true;
        }
        return false;
    }
}

