/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateFieldOrPropertyHandler;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.generation.ORMToAnnotationsConverter;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.AbstractPersistenceAction;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectManipulatorBase<T extends PersistentObject>
extends AbstractPersistenceManipulator<T>
implements PersistentObjectManipulator<T> {
    private boolean myUseExtendedColumnProperties;

    public ObjectManipulatorBase(T target) {
        super(target);
    }

    @Nullable
    public PsiClass getManipulatorTargetClass() {
        return (PsiClass)((PersistentObject)this.getManipulatorTarget()).getClazz().getValue();
    }

    @Nullable
    protected static PersistentRelationshipAttribute getRelationshipTarget(PsiType type, String attributeName) {
        PsiClass psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY) continue;
            for (PersistentAttribute attribute : role.getPersistentObject().getObjectModelHelper().getAttributes()) {
                if (!(attribute instanceof PersistentRelationshipAttribute) || !Comparing.equal((String)((String)attribute.getName().getValue()), (String)attributeName)) continue;
                return (PersistentRelationshipAttribute)attribute;
            }
        }
        return null;
    }

    public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
        if (affectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedElements", "com/intellij/jpa/model/manipulators/ObjectManipulatorBase", "addAffectedElements"));
        }
        super.addAffectedElements(affectedElements);
        ContainerUtil.addIfNotNull(affectedElements, (Object)this.getManipulatorTargetClass());
    }

    public void setGenerateColumnProperties(boolean useIt) {
        this.myUseExtendedColumnProperties = useIt;
    }

    public boolean isGenerateColumnProperties() {
        return this.myUseExtendedColumnProperties;
    }

    public PsiClass ensureClassExists() throws IncorrectOperationException {
        PsiClass psiClass = this.getManipulatorTargetClass();
        if (psiClass != null) {
            return psiClass;
        }
        String qname = JpaUtil.getQualifiedName((PersistentObject)this.getManipulatorTarget());
        return ORMToAnnotationsConverter.createClass(((PersistentObject)this.getManipulatorTarget()).getModule(), qname);
    }

    public PsiClass ensureIdClassExists(List<PersistentAttribute> idAttributes) throws IncorrectOperationException {
        PsiClass aClass;
        assert (this.getManipulatorTarget() instanceof PersistentEntityBase);
        PersistentEntityBase entity = (PersistentEntityBase)this.getManipulatorTarget();
        PsiClass existingClass = (PsiClass)entity.getIdClassValue().getValue();
        String qName = JpaUtil.getQualifiedName((PersistentObject)entity, entity.getIdClassValue().getStringValue());
        PsiClass psiClass = aClass = existingClass != null ? existingClass : ORMToAnnotationsConverter.createClass(((PersistentObject)this.getManipulatorTarget()).getModule(), qName);
        if (aClass != null) {
            PsiClass serializableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.io.Serializable", ProjectScope.getAllScope((Project)aClass.getProject()));
            if (serializableClass == null || !aClass.isInheritorDeep(serializableClass, null)) {
                PsiReferenceList implementsList = aClass.getImplementsList();
                assert (implementsList != null);
                implementsList.addBefore((PsiElement)JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createReferenceElementByFQClassName("java.io.Serializable", aClass.getResolveScope()), null);
            }
            ArrayList<PsiField> fields = new ArrayList<PsiField>();
            for (PersistentAttribute attribute : idAttributes) {
                if (!attribute.getAttributeModelHelper().isIdAttribute()) continue;
                PsiMember psiMember = attribute.getPsiMember();
                PsiAnnotation[] psiAnnotations = psiMember != null ? psiMember.getModifierList().getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
                GenerateFieldOrPropertyHandler handler = ObjectManipulatorBase.ensurePropertyExistsInner(aClass, (String)attribute.getName().getValue(), JpaUtil.getAttributeTypeOrDefault(attribute), attribute.getAttributeModelHelper().isFieldAccess() ? PropertyMemberType.FIELD : PropertyMemberType.GETTER, psiAnnotations);
                ContainerUtil.addIfNotNull(fields, (Object)((PsiField)handler.findExistingMember(aClass, PropertyMemberType.FIELD)));
            }
            ORMToAnnotationsConverter.ensureEqualsAndHashCodeImplemented(aClass, fields);
        }
        return aClass;
    }

    public PsiMember ensurePropertyExists(PsiClass psiClass, String name, PsiType type, PropertyMemberType memberType, PsiAnnotation ... psiAnnotations) throws IncorrectOperationException {
        GenerateFieldOrPropertyHandler handler = ObjectManipulatorBase.ensurePropertyExistsInner(psiClass, name, type, memberType, psiAnnotations);
        return handler.findExistingMember(psiClass, memberType);
    }

    private static GenerateFieldOrPropertyHandler ensurePropertyExistsInner(PsiClass psiClass, String name, PsiType type, PropertyMemberType memberType, PsiAnnotation ... psiAnnotations) throws IncorrectOperationException {
        GenerateFieldOrPropertyHandler handler = new GenerateFieldOrPropertyHandler(name, type, memberType, psiAnnotations);
        List prototypes = handler.generateMemberPrototypes(psiClass, ClassMember.EMPTY_ARRAY);
        int offset = psiClass.getLastChild().getTextOffset();
        List resultMembers = GenerateMembersUtil.insertMembersAtOffset((PsiClass)psiClass, (int)offset, (List)prototypes);
        for (GenerationInfo member : resultMembers) {
            PsiMember psiMember;
            PsiUtil.setModifierProperty((PsiModifierListOwner)psiMember, (String)"public", (!((psiMember = member.getPsiMember()) instanceof PsiField) ? 1 : 0) != 0);
        }
        return handler;
    }

    public static abstract class MyAttributeAction<T extends ObjectManipulatorBase<? extends PersistentObject>>
    extends AbstractPersistenceAction<T> {
        protected PersistenceFacet myFacet;
        protected PersistencePackage myUnit;
        protected UserResponse.AttributeInfo myInfo;
        protected PersistentRelationshipAttributeManipulator<?> myTargetManipulator;
        protected final AttributeType myAttributeType;
        private String myDefaultName;

        public MyAttributeAction(T manipulator, AttributeType attributeType) {
            super(manipulator, JpaMessages.message((String)"action.create.attr.1", (Object[])new Object[]{attributeType.getTypeName()}), attributeType.getTypeName(), attributeType.getIcon());
            this.myAttributeType = attributeType;
        }

        public Object getActionKey() {
            AttributeType annoType = AttributeType.getAnnotationAttributeType((AttributeType)this.myAttributeType);
            return annoType != null ? annoType : this.myAttributeType;
        }

        public int getGroupId() {
            return 50;
        }

        public void update(AnActionEvent e) {
            this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
            this.myUnit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(e.getDataContext());
            String defaultName = StringUtil.decapitalize((String)this.myAttributeType.getTypeName()).replace(" ", "");
            this.myDefaultName = StringUtil.notNullize((String)((String)PsiElementRenameHandler.DEFAULT_NAME.getData(e.getDataContext())), (String)defaultName);
            this.getPresentation().setEnabled(this.myFacet != null);
        }

        public boolean preInvoke(UserResponse response) {
            this.myInfo = response.getAttributeName((PersistentObject)((ObjectManipulatorBase)this.getManipulator()).getManipulatorTarget(), (PersistentAttributeType)this.myAttributeType, this.getRelationshipType(), this.myFacet.getModelValidator(this.myUnit), JpaMessages.message((String)"dialog.title.new.typename", (Object[])new Object[]{this.getPresentation().getText()}), this.myDefaultName);
            if (this.myInfo != null && this.getRelationshipType() != null) {
                PersistentRelationshipAttribute targetAttribute = ObjectManipulatorBase.getRelationshipTarget(this.myInfo.type, this.myInfo.targetAttribute);
                PersistentRelationshipAttributeManipulator tmp = (PersistentRelationshipAttributeManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)targetAttribute, PersistentRelationshipAttributeManipulator.class);
                this.myTargetManipulator = targetAttribute == null ? null : tmp;
            } else {
                this.myTargetManipulator = null;
            }
            return this.myInfo != null && StringUtil.isNotEmpty((String)this.myInfo.name);
        }

        @Nullable
        protected abstract RelationshipType getRelationshipType();

        public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
            if (affectedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedElements", "com/intellij/jpa/model/manipulators/ObjectManipulatorBase$MyAttributeAction", "addAffectedElements"));
            }
            ((ObjectManipulatorBase)this.getManipulator()).addAffectedElements(affectedElements);
            if (this.myTargetManipulator != null) {
                this.myTargetManipulator.addAffectedElements(affectedElements);
            }
        }

        protected PsiElement getTargetElement() {
            return ((PersistentObject)((ObjectManipulatorBase)this.getManipulator()).getManipulatorTarget()).getIdentifyingPsiElement();
        }

        public void invokeAction(@NotNull Collection<PsiElement> result) throws IncorrectOperationException {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/model/manipulators/ObjectManipulatorBase$MyAttributeAction", "invokeAction"));
            }
            PsiClass psiClass = ((ObjectManipulatorBase)this.getManipulator()).getManipulatorTargetClass();
            if (psiClass != null) {
                try {
                    PsiAnnotation[] psiAnnotations = this.createAnnotations(psiClass);
                    PsiMember targetMember = ((ObjectManipulatorBase)this.getManipulator()).ensurePropertyExists(psiClass, this.myInfo.name, this.myInfo.type, this.myInfo.fieldAccess ? PropertyMemberType.FIELD : PropertyMemberType.GETTER, psiAnnotations);
                    if (this.myTargetManipulator != null) {
                        this.myTargetManipulator.setMappedByAndInverse(this.myInfo.name, !this.myInfo.inverse);
                    }
                    result.add((PsiElement)targetMember);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        protected PsiAnnotation[] createAnnotations(PsiClass context) throws IncorrectOperationException {
            return PsiAnnotation.EMPTY_ARRAY;
        }

        public AttributeType getAttributeType() {
            return this.myAttributeType;
        }
    }
}

