/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.server.GlassfishConfigBase;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishJavaConfigProcessor;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GlassfishDebugConfig
extends GlassfishConfigBase {
    private static final Logger LOG = Logger.getInstance(GlassfishDebugConfig.class);
    private static final String DEFAULT_PORT = "9009";
    private static final JdwpOption TRANSPORT_OPTION = new JdwpOption("transport", "\\w+");
    private static final JdwpOption PORT_OPTION = new JdwpOption("address", "\\d+");
    private static final JdwpOption SERVER_OPTION = new JdwpOption("server", "[yn]");
    private static final JdwpOption SUSPEND_OPTION = new JdwpOption("suspend", "[yn]");
    private static String DEBUG_OPTIONS_NAME = "debug-options";
    private static String DEBUG_ENABLED_NAME = "debug-enabled";
    private static String DEBUG_ENABLED_VALUE = "false";
    private static final String FLAG_PARAMETER = "-Xdebug";
    private static final String JDWP_PARAMETER_OLD_PREFIX = "-Xrunjdwp:";
    private static final String JDWP_PARAMETER_NEW_PREFIX = "-agentlib:jdwp=";
    private static final GlassfishConfigBase.GlassfishConfigFactoryBase<GlassfishDebugConfig> FACTORY = new GlassfishConfigBase.GlassfishConfigFactoryBase<GlassfishDebugConfig>(){

        @NotNull
        public GlassfishDebugConfig createConfig(GlassfishLocalModel data) {
            GlassfishDebugConfig glassfishDebugConfig = new GlassfishDebugConfig(data);
            if (glassfishDebugConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/server/GlassfishDebugConfig$1", "createConfig"));
            }
            return glassfishDebugConfig;
        }
    };
    @NonNls
    private String myTransport;
    @NonNls
    private String myPort;
    @NonNls
    private String myServer;
    @NonNls
    private String mySuspend;
    private boolean myDisabled;

    public static boolean isDebugParameter(String vmParameter) {
        return FLAG_PARAMETER.equals(vmParameter) || vmParameter.startsWith(JDWP_PARAMETER_NEW_PREFIX) || vmParameter.startsWith(JDWP_PARAMETER_OLD_PREFIX);
    }

    private GlassfishDebugConfig(GlassfishLocalModel model) {
        super(model);
    }

    protected void update(GlassfishLocalModel data) {
        this.myPort = null;
        this.myServer = null;
        this.mySuspend = null;
        this.myTransport = null;
        new DebugConfigProcessor(this.getDomainConfig()){

            @Override
            protected void doProcessDebugConfig(File file, Document doc, Element javaConfig, String debugOptions, String debugEnabled, Ref<Boolean> save) {
                GlassfishDebugConfig.this.myTransport = TRANSPORT_OPTION.getValue(debugOptions);
                GlassfishDebugConfig.this.myPort = PORT_OPTION.getValue(debugOptions);
                GlassfishDebugConfig.this.myServer = SERVER_OPTION.getValue(debugOptions);
                GlassfishDebugConfig.this.mySuspend = SUSPEND_OPTION.getValue(debugOptions);
                GlassfishDebugConfig.this.myDisabled = StringUtil.isEmpty((String)debugEnabled) || DEBUG_ENABLED_VALUE.equals(debugEnabled);
            }
        }.processConfig();
    }

    private void fix(final String fixedDebugOptions) {
        new DebugConfigProcessor(this.getDomainConfig()){

            @Override
            protected void doProcessDebugConfig(File file, Document doc, Element javaConfig, String debugOptions, String debugEnabled, Ref<Boolean> save) throws IOException {
                javaConfig.setAttribute(DEBUG_OPTIONS_NAME, fixedDebugOptions);
                javaConfig.setAttribute(DEBUG_ENABLED_NAME, DEBUG_ENABLED_VALUE);
                save.set((Object)true);
            }
        }.processConfig();
    }

    static String get(GlassfishLocalModel model) {
        GlassfishDebugConfig config = FACTORY.get(model);
        return config != null && config.myPort != null ? config.myPort : DEFAULT_PORT;
    }

    static void check(GlassfishLocalModel model, String port) throws RuntimeConfigurationException {
        JavaParameters javaParameters = new JavaParameters();
        try {
            javaParameters.setJdk(model.getJre());
            DebuggerManagerImpl.createDebugParameters((JavaParameters)javaParameters, (boolean)true, (int)DebuggerSettings.getInstance().DEBUGGER_TRANSPORT, (String)port, (boolean)false);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return;
        }
        boolean isFlagPresent = false;
        boolean isNewJdwpPrefix = false;
        String transport = null;
        for (String vmParameter : javaParameters.getVMParametersList().getList()) {
            if (FLAG_PARAMETER.equals(vmParameter)) {
                isFlagPresent = true;
                continue;
            }
            if (!vmParameter.startsWith(JDWP_PARAMETER_NEW_PREFIX) && !vmParameter.startsWith(JDWP_PARAMETER_OLD_PREFIX)) continue;
            if (vmParameter.startsWith(JDWP_PARAMETER_NEW_PREFIX)) {
                isNewJdwpPrefix = true;
            }
            transport = TRANSPORT_OPTION.getValue(vmParameter);
        }
        GlassfishDebugConfig config = FACTORY.get(model);
        if (config != null) {
            String serverValue = "n";
            String suspendValue = "y";
            if (!(Comparing.equal((String)config.myTransport, transport) && Comparing.equal((String)config.myPort, (String)port) && serverValue.equals(config.myServer) && suspendValue.equals(config.mySuspend) && config.myDisabled)) {
                String message = GlassfishBundle.getText("GlassfishRemoteModel.error.debug", port);
                RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning(message);
                if (config.getDomainConfig().getFile().canWrite()) {
                    StringBuilder fixedDebugOptions = new StringBuilder();
                    if (isFlagPresent) {
                        fixedDebugOptions.append(FLAG_PARAMETER);
                        fixedDebugOptions.append(" ");
                    }
                    fixedDebugOptions.append(isNewJdwpPrefix ? JDWP_PARAMETER_NEW_PREFIX : JDWP_PARAMETER_OLD_PREFIX);
                    String optionSeparator = ",";
                    fixedDebugOptions.append(TRANSPORT_OPTION.createNameValue(transport));
                    fixedDebugOptions.append(optionSeparator);
                    fixedDebugOptions.append(PORT_OPTION.createNameValue(port));
                    fixedDebugOptions.append(optionSeparator);
                    fixedDebugOptions.append(SERVER_OPTION.createNameValue(serverValue));
                    fixedDebugOptions.append(optionSeparator);
                    fixedDebugOptions.append(SUSPEND_OPTION.createNameValue(suspendValue));
                    warning.setQuickFix(() -> config.fix(fixedDebugOptions.toString()));
                }
                throw warning;
            }
        }
    }

    private static class JdwpOption {
        private final String myName;
        private final Pattern myPattern;

        public JdwpOption(String name, String valuePattern) {
            this.myName = name;
            this.myPattern = Pattern.compile("^(?:.*\\W)?" + name + "=(" + valuePattern + ")(?:,.*)?$");
        }

        @Nullable
        public String getValue(String options) {
            Matcher matcher;
            if (options != null && (matcher = this.myPattern.matcher(options)).matches()) {
                return matcher.group(1);
            }
            return null;
        }

        public String createNameValue(String value) {
            return this.myName + "=" + value;
        }
    }

    private static abstract class DebugConfigProcessor
    extends GlassfishJavaConfigProcessor {
        public DebugConfigProcessor(GlassfishDomainConfig domainConfig) {
            super(domainConfig);
        }

        @Override
        protected void doProcessJavaConfig(File file, Document doc, Element serverConfig, Element javaConfig, Ref<Boolean> save) throws IOException {
            this.doProcessDebugConfig(file, doc, javaConfig, javaConfig.getAttributeValue(DEBUG_OPTIONS_NAME), javaConfig.getAttributeValue(DEBUG_ENABLED_NAME), save);
        }

        protected abstract void doProcessDebugConfig(File var1, Document var2, Element var3, String var4, String var5, Ref<Boolean> var6) throws IOException;
    }
}

