/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.loadgroup;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.module.view.common.attributes.JavaeeTreeTableView;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossAddAction;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossContainsColumn;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossEagerColumn;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossLazyColumn;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossLoadGroupColumn;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossLoadGroupsNode;
import com.intellij.javaee.oss.jboss.editor.loadgroup.JBossRemoveAction;
import com.intellij.javaee.oss.jboss.model.JBossCmpBean;
import com.intellij.javaee.oss.util.BooleanRenderer;
import com.intellij.javaee.oss.util.TreeExpanderImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossLoadGroupsEditor
extends JavaeeTreeTableView {
    private final JBossCmpBean cmp;

    public JBossLoadGroupsEditor(EntityBean bean, JBossCmpBean cmp) {
        super(cmp.getManager().getProject(), (JavaeeNodeDescriptor)new JBossLoadGroupsNode(bean, cmp));
        this.cmp = cmp;
        this.getTreeTableView().setShowVerticalLines(true);
        this.getTreeTableView().setIntercellSpacing((Dimension)JBUI.size((int)1, (int)0));
        this.getTreeTableView().setDefaultRenderer(Boolean.class, (TableCellRenderer)new BooleanRenderer((JTable)this.getTreeTableView()));
        this.init();
    }

    protected boolean isShowTree() {
        return !this.cmp.getLoadGroups().getLoadGroups().isEmpty();
    }

    @NotNull
    protected String getEmptyPaneText() {
        String string = JBossBundle.getText("JBossLoadGroupsEditor.empty", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/editor/loadgroup/JBossLoadGroupsEditor", "getEmptyPaneText"));
        }
        return string;
    }

    protected ColumnInfo<?, ?>[] createColumnInfos() {
        return new ColumnInfo[]{new JBossLoadGroupColumn(this.getProject()), new JBossEagerColumn(this.cmp), new JBossLazyColumn(this.cmp), new JBossContainsColumn()};
    }

    @Nullable
    protected ActionGroup createToolbarActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new JBossAddAction(this.cmp, this.getComponent()));
        actions.add((AnAction)new JBossRemoveAction(this.cmp, this.getTreeTableView()));
        actions.addSeparator();
        actions.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        actions.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        return actions;
    }
}

