/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.server.JBossExtensions;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JBossDeploymentProvider
extends JavaeeDeploymentProvider {
    private static final Logger LOG = Logger.getInstance(JBossDeploymentProvider.class);
    public static final DeploymentMethod STAGING = new DeploymentMethod(JBossBundle.getText("JBossDeploymentProvider.method.staging", new Object[0]), false, true);
    public static final DeploymentMethod NATIVE = new DeploymentMethod(JBossBundle.getText("JBossDeploymentProvider.method.native", new Object[0]), false, true);
    private static final DeploymentMethod[] ourDeploymentMethods = new DeploymentMethod[]{STAGING, NATIVE};

    public DeploymentMethod[] getAvailableMethods() {
        return ourDeploymentMethods;
    }

    public Collection<? extends ArtifactType> getSupportedArtifactTypes() {
        ArrayList<JarArtifactType> result = new ArrayList<JarArtifactType>();
        result.addAll(super.getSupportedArtifactTypes());
        result.add(JarArtifactType.getInstance());
        return result;
    }

    public ExternalFileDeploymentProvider getExternalFileDeploymentProvider() {
        final ExternalFileDeploymentProvider commonProvider = super.getExternalFileDeploymentProvider();
        LOG.assertTrue(commonProvider != null);
        final ExternalFileDeploymentProvider specificProvider = JavaeeDeploymentUtil.getInstance().createExternalFileDeploymentProvider(true, JBossExtensions.SPECIFIC_EXTENSIONS);
        final FileFilter resultFileFilter = pathname -> commonProvider.getDeployableFileFilter().accept(pathname) || specificProvider.getDeployableFileFilter().accept(pathname);
        return new ExternalFileDeploymentProvider(){

            public boolean isDirectoriesAllowed() {
                return commonProvider.isDirectoriesAllowed() || specificProvider.isDirectoriesAllowed();
            }

            @NotNull
            public FileFilter getDeployableFileFilter() {
                FileFilter fileFilter = resultFileFilter;
                if (fileFilter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/server/JBossDeploymentProvider$1", "getDeployableFileFilter"));
                }
                return fileFilter;
            }
        };
    }

    public boolean isDeployOrderMatter() {
        return true;
    }

    public boolean isNeedUndeployOnDisconnect() {
        return true;
    }
}

