/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.parser;

import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.el.ELParserUtil;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELParameterList;
import com.intellij.psi.tree.IElementType;
import com.intellij.spring.el.lexer.SpringELTokenType;
import com.intellij.spring.el.psi.SpringELInlineMapEntry;
import com.intellij.spring.el.psi.SpringELNewExpression;
import com.intellij.spring.el.psi.SpringELParameterList;
import com.intellij.spring.el.psi.SpringELPropertyReference;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.impl.SpringELBeanReferenceExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELLiteralExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELMethodCallExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELTypeExpressionImpl;
import com.intellij.spring.el.psi.impl.SpringELVariableImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringELParserUtil
extends ELParserUtil {
    @NotNull
    public static ELParameterList getParameterList(SpringELMethodCallExpressionImpl expression) {
        SpringELParameterList springELParameterList = expression.getELParameterList();
        if (springELParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getParameterList"));
        }
        return springELParameterList;
    }

    @NotNull
    public static PsiReference[] getReferences(SpringELVariableImpl variable) {
        if (variable.getParent() instanceof SpringELQualifiedType || variable.getParent() instanceof SpringELInlineMapEntry) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)variable);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiType getType(SpringELTypeExpressionImpl expression) {
        SpringELQualifiedType type = expression.getELQualifiedType();
        return type == null ? null : type.getType();
    }

    @Nullable
    public static PsiType getType(SpringELNewExpression expression) {
        SpringELQualifiedType type = expression.getELQualifiedType();
        return type == null ? null : type.getType();
    }

    @Nullable
    public static PsiType getType(SpringELBeanReferenceExpressionImpl expression) {
        return ELResolveUtil.resolveContextAsType((ELExpression)expression.getELVariable());
    }

    @NotNull
    public static Class getTypeClass(SpringELLiteralExpressionImpl expression) {
        IElementType type = expression.getNode().getFirstChildNode().getElementType();
        if (SpringELTokenType.SPEL_STRING_LITERALS.contains(type)) {
            if (String.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getTypeClass"));
            }
            return String.class;
        }
        if (type == SpringELTokenType.SPEL_INTEGER_LITERAL) {
            if (Integer.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getTypeClass"));
            }
            return Integer.class;
        }
        if (type == SpringELTokenType.SPEL_FLOATING_POINT_LITERAL) {
            if (Float.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getTypeClass"));
            }
            return Float.class;
        }
        if (type == SpringELTokenType.SPEL_TRUE || type == SpringELTokenType.SPEL_FALSE) {
            if (Boolean.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getTypeClass"));
            }
            return Boolean.class;
        }
        if (Object.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getTypeClass"));
        }
        return Object.class;
    }

    @NotNull
    public static PsiReference getReference(SpringELPropertyReference expression) {
        PropertyReference propertyReference = new PropertyReference(expression.getText(), (PsiElement)expression, null, false);
        if (propertyReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/parser/SpringELParserUtil", "getReference"));
        }
        return propertyReference;
    }
}

