/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml;

import com.intellij.lang.ASTFactory;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HAMLInjectedASTFactory;
import org.jetbrains.plugins.haml.psi.HAMLElementTypes;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLAttributeImpl;
import org.jetbrains.plugins.haml.psi.impl.HAMLAttributeValueImpl;
import org.jetbrains.plugins.haml.psi.impl.HAMLClassOrIdImpl;
import org.jetbrains.plugins.haml.psi.impl.HAMLDoctypeImpl;
import org.jetbrains.plugins.haml.psi.impl.HAMLDocumentImpl;
import org.jetbrains.plugins.haml.psi.impl.HAMLPseudoWhitespaceImpl;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;

public class HAMLAstFactory
extends ASTFactory
implements HAMLTokenTypes,
HAMLElementTypes {
    public CompositeElement createComposite(IElementType type) {
        for (HAMLInjectedASTFactory ext : (HAMLInjectedASTFactory[])Extensions.getExtensions(HAMLInjectedASTFactory.EP_NAME)) {
            CompositeElement element = ext.createComposite(type);
            if (element == null) continue;
            return element;
        }
        if (type == HAML_TAG) {
            return new HAMLTagImpl();
        }
        if (type == HAML_ARGUMENT) {
            return new HAMLAttributeImpl();
        }
        if (type == HAML_ARGUMENT_VALUE) {
            return new HAMLAttributeValueImpl();
        }
        if (type == HAML_DOCTYPE) {
            return new HAMLDoctypeImpl();
        }
        if (type == HAML_DOCUMENT) {
            return new HAMLDocumentImpl();
        }
        if (type == HAMLElementTypes.XML_END_TAG_START) {
            return new HAMLPseudoWhitespaceImpl(XmlTokenType.XML_END_TAG_START);
        }
        if (type == HAMLElementTypes.XML_TAG_END) {
            return new HAMLPseudoWhitespaceImpl(XmlTokenType.XML_TAG_END);
        }
        if (type == HAMLElementTypes.HAML_CLASS_OR_ID) {
            return new HAMLClassOrIdImpl();
        }
        if (type == HAMLElementTypes.HAML_PSEUDO_WHITESPACE) {
            return new HAMLPseudoWhitespaceImpl(type);
        }
        return super.createComposite(type);
    }

    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        for (HAMLInjectedASTFactory ext : (HAMLInjectedASTFactory[])Extensions.getExtensions(HAMLInjectedASTFactory.EP_NAME)) {
            LazyParseableElement element = ext.createLazy(type, text);
            if (element == null) continue;
            return element;
        }
        return super.createLazy(type, text);
    }

    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/haml/HAMLAstFactory", "createLeaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/haml/HAMLAstFactory", "createLeaf"));
        }
        for (HAMLInjectedASTFactory ext : (HAMLInjectedASTFactory[])Extensions.getExtensions(HAMLInjectedASTFactory.EP_NAME)) {
            LeafElement element = ext.createLeaf(type, text);
            if (element == null) continue;
            return element;
        }
        return super.createLeaf(type, text);
    }
}

